/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.server.rrd.sampler.NodeIdsInUseSampleable;
import org.neo4j.test.TestGraphDatabaseFactory;

public class NodeIdsInUseSampleableTest {
    public GraphDatabaseAPI db;
    public NodeIdsInUseSampleable sampleable;

    @Test
    public void emptyDbHasZeroNodesInUse() {
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void addANodeAndSampleableGoesUp() {
        double oldValue = this.sampleable.getValue();
        this.createNode(this.db);
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(oldValue)));
    }

    private void createNode(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        DependencyResolver dependencyResolver = this.db.getDependencyResolver();
        this.sampleable = new NodeIdsInUseSampleable((NeoStoresSupplier)dependencyResolver.resolveDependency(NeoStoresSupplier.class));
    }

    @After
    public void shutdown() throws Throwable {
        this.db.shutdown();
    }
}

