/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class ConfigureEnabledManagementConsolesDocIT
extends ExclusiveServerTestBase {
    private NeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldBeAbleToExplicitlySetConsolesToEnabled() throws Exception {
        this.server = CommunityServerBuilder.server().withProperty(Configurator.MANAGEMENT_CONSOLE_ENGINES, "").withProperty(ServerInternalSettings.webadmin_enabled.name(), "true").usingDatabaseDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        Assert.assertThat((Object)this.exec("ls", "shell").getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @Test
    public void shellConsoleShouldBeEnabledByDefault() throws Exception {
        this.server = CommunityServerBuilder.server().withProperty(ServerInternalSettings.webadmin_enabled.name(), "true").usingDatabaseDir(this.folder.directory(this.name.getMethodName()).getAbsolutePath()).build();
        this.server.start();
        Assert.assertThat((Object)this.exec("ls", "shell").getStatus(), (Matcher)Matchers.is((Object)200));
    }

    private JaxRsResponse exec(String command, String engine) {
        return RestRequest.req().post(this.server.baseUri() + "db/manage/server/console", "{\"engine\":\"" + engine + "\"," + "\"command\":\"" + command + "\\n\"}");
    }
}

