/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.database.Database;

public class WrappedDatabase
extends LifecycleAdapter
implements Database {
    private final GraphDatabaseAPI graph;

    public static Database.Factory wrappedDatabase(final GraphDatabaseAPI db) {
        return new Database.Factory(){

            @Override
            public Database newDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new WrappedDatabase(db);
            }
        };
    }

    public WrappedDatabase(GraphDatabaseAPI graph) {
        this.graph = graph;
        try {
            this.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public String getLocation() {
        return this.graph.getStoreDir();
    }

    @Override
    public GraphDatabaseAPI getGraph() {
        return this.graph;
    }

    @Override
    public boolean isRunning() {
        return true;
    }
}

