/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.management.console;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.webadmin.console.ConsoleSessionCreator;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;

public class SessionFactoryImpl
implements ConsoleSessionFactory {
    private static final Collection<ConsoleSessionCreator> creators = IteratorUtil.asCollection(ServiceLoader.load(ConsoleSessionCreator.class));
    private final HttpSession httpSession;
    private final CypherExecutor cypherExecutor;
    private final Map<String, ConsoleSessionCreator> engineCreators = new HashMap<String, ConsoleSessionCreator>();
    private final HttpServletRequest request;

    public SessionFactoryImpl(HttpServletRequest request, List<String> supportedEngines, CypherExecutor cypherExecutor) {
        this.request = request;
        this.httpSession = request.getSession(true);
        this.cypherExecutor = cypherExecutor;
        this.enableEngines(supportedEngines);
    }

    @Override
    public ScriptSession createSession(String engineName, Database database, LogProvider logProvider) {
        if (this.engineCreators.containsKey(engineName = engineName.toLowerCase())) {
            return this.getOrInstantiateSession(database, engineName + "-console-session", this.engineCreators.get(engineName), logProvider);
        }
        throw new IllegalArgumentException("Unknown console engine '" + engineName + "'.");
    }

    @Override
    public Iterable<String> supportedEngines() {
        return this.engineCreators.keySet();
    }

    private ScriptSession getOrInstantiateSession(Database database, String key, ConsoleSessionCreator creator, LogProvider logProvider) {
        Object session = this.httpSession.getAttribute(key);
        if (session == null) {
            session = creator.newSession(database, this.cypherExecutor, this.request, logProvider);
            this.httpSession.setAttribute(key, session);
        }
        return (ScriptSession)session;
    }

    private void enableEngines(List<String> supportedEngines) {
        for (ConsoleSessionCreator creator : creators) {
            for (String engineName : supportedEngines) {
                if (!creator.name().equalsIgnoreCase(engineName)) continue;
                this.engineCreators.put(engineName.toLowerCase(), creator);
            }
        }
    }
}

