/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Map;
import org.neo4j.function.Function;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.ObjectToRepresentationConverter;
import org.neo4j.server.rest.repr.Representation;

public abstract class CypherPlanRepresentation
extends MappingRepresentation {
    private CypherPlanRepresentation() {
        super("plan");
    }

    protected abstract ExecutionPlanDescription getPlan();

    protected void serialize(MappingSerializer mappingSerializer) {
        ExecutionPlanDescription planDescription = this.getPlan();
        mappingSerializer.putString("name", planDescription.getName());
        Map arguments = planDescription.getArguments();
        MappingRepresentation argsRepresentation = ObjectToRepresentationConverter.getMapRepresentation(arguments);
        mappingSerializer.putMapping("args", argsRepresentation);
        if (planDescription.hasProfilerStatistics()) {
            ExecutionPlanDescription.ProfilerStatistics stats = planDescription.getProfilerStatistics();
            mappingSerializer.putNumber("rows", (Number)stats.getRows());
            mappingSerializer.putNumber("dbHits", (Number)stats.getDbHits());
        }
        mappingSerializer.putList("children", new ListRepresentation("children", (Iterable)new IterableWrapper<Representation, ExecutionPlanDescription>((Iterable)planDescription.getChildren()){

            protected Representation underlyingObjectToObject(ExecutionPlanDescription childPlan) {
                return CypherPlanRepresentation.newFromPlan(childPlan);
            }
        }));
    }

    public static CypherPlanRepresentation newFromProvider(final Function<Object, ExecutionPlanDescription> planProvider) {
        return new CypherPlanRepresentation(){
            private ExecutionPlanDescription plan;
            private boolean fetched;
            {
                this.plan = null;
                this.fetched = false;
            }

            @Override
            protected ExecutionPlanDescription getPlan() {
                if (!this.fetched) {
                    this.plan = (ExecutionPlanDescription)planProvider.apply(null);
                    this.fetched = true;
                }
                return this.plan;
            }
        };
    }

    public static CypherPlanRepresentation newFromPlan(final ExecutionPlanDescription plan) {
        return new CypherPlanRepresentation(){

            @Override
            protected ExecutionPlanDescription getPlan() {
                return plan;
            }
        };
    }
}

