/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd.sampler;

import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.server.rrd.Sampleable;
import org.rrd4j.DsType;

public abstract class DatabasePrimitivesSampleableBase
implements Sampleable {
    private final NeoStoresSupplier neoStore;
    private final AvailabilityGuard guard;
    private double lastReadValue = 0.0;

    public DatabasePrimitivesSampleableBase(NeoStoresSupplier neoStore, AvailabilityGuard guard) {
        if (neoStore == null) {
            throw new RuntimeException("Database sampler needs a NeoStores to work, was given null.");
        }
        this.neoStore = neoStore;
        this.guard = guard;
    }

    @Override
    public double getValue() {
        if (this.guard.isAvailable(0L)) {
            try {
                this.lastReadValue = this.readValue((NeoStores)this.neoStore.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.lastReadValue;
    }

    protected abstract double readValue(NeoStores var1);

    @Override
    public DsType getType() {
        return DsType.GAUGE;
    }
}

