/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.server.ExclusiveServerTestBase;

public abstract class BaseBootstrapperTest
extends ExclusiveServerTestBase {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    protected Bootstrapper bootstrapper;

    protected String[] commandLineConfig(String ... params) {
        ArrayList<String> config = new ArrayList<String>();
        for (String param : params) {
            config.add(param);
        }
        return config.toArray(new String[config.size()]);
    }

    @Before
    public void before() {
        this.bootstrapper = this.newBootstrapper();
    }

    @After
    public void after() {
        if (this.bootstrapper != null) {
            this.bootstrapper.stop();
        }
    }

    protected abstract Bootstrapper newBootstrapper();

    @Test
    public void shouldStartStopNeoServerWithoutAnyConfigFiles() {
        int resultCode = CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig("-c", this.configOption(ServerInternalSettings.legacy_db_location.name(), this.tempDir.getRoot().getAbsolutePath())));
        Assert.assertEquals((long)0L, (long)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
    }

    @Test
    public void canSpecifyConfigFile() throws Throwable {
        File configFile = this.tempDir.newFile("neo4j.config");
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "ourcustomvalue"}), (File)configFile);
        CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig("-C", configFile.getAbsolutePath(), "-c", this.configOption(ServerInternalSettings.legacy_db_location.name(), this.tempDir.getRoot().getAbsolutePath())));
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"ourcustomvalue"));
    }

    @Test
    public void canOverrideConfigValues() throws Throwable {
        File configFile = this.tempDir.newFile("neo4j.config");
        MapUtil.store((Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "thisshouldnotshowup"}), (File)configFile);
        CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig("-C", configFile.getAbsolutePath(), "-c", this.configOption(GraphDatabaseSettings.forced_kernel_id.name(), "mycustomvalue"), "-c", this.configOption(ServerInternalSettings.legacy_db_location.name(), this.tempDir.getRoot().getAbsolutePath())));
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"mycustomvalue"));
    }

    protected String configOption(String key, String value) {
        return key + "=" + value;
    }
}

