/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.WebApplication;
import java.io.InputStream;
import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.web.XForwardFilter;

public class XForwardFilterTest {
    private static final String X_FORWARD_HOST_HEADER_KEY = "X-Forwarded-Host";
    private static final String X_FORWARD_PROTO_HEADER_KEY = "X-Forwarded-Proto";

    @Test
    public void shouldSetTheBaseUriToTheSameValueAsTheXForwardHostHeader() throws Exception {
        String xForwardHostAndPort = "jimwebber.org:1234";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_HOST_HEADER_KEY, (Object)"jimwebber.org:1234");
        ContainerRequest request = new ContainerRequest((WebApplication)Mockito.mock(WebApplication.class), "GET", URI.create("http://iansrobinson.com"), URI.create("http://iansrobinson.com/foo/bar"), headers, (InputStream)Mockito.mock(InputStream.class));
        ContainerRequest result = filter.filter(request);
        Assert.assertThat((Object)result.getBaseUri().toString(), (Matcher)CoreMatchers.containsString((String)"jimwebber.org:1234"));
    }

    @Test
    public void shouldSetTheRequestUriToTheSameValueAsTheXForwardHostHeader() throws Exception {
        String xForwardHostAndPort = "jimwebber.org:1234";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_HOST_HEADER_KEY, (Object)"jimwebber.org:1234");
        ContainerRequest request = new ContainerRequest((WebApplication)Mockito.mock(WebApplication.class), "GET", URI.create("http://iansrobinson.com"), URI.create("http://iansrobinson.com/foo/bar"), headers, (InputStream)Mockito.mock(InputStream.class));
        ContainerRequest result = filter.filter(request);
        Assert.assertTrue((boolean)result.getRequestUri().toString().startsWith("http://jimwebber.org:1234"));
    }

    @Test
    public void shouldSetTheBaseUriToTheSameProtocolAsTheXForwardProtoHeader() throws Exception {
        String theProtocol = "https";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_PROTO_HEADER_KEY, (Object)"https");
        ContainerRequest request = new ContainerRequest((WebApplication)Mockito.mock(WebApplication.class), "GET", URI.create("http://jimwebber.org:1234"), URI.create("http://jimwebber.org:1234/foo/bar"), headers, (InputStream)Mockito.mock(InputStream.class));
        ContainerRequest result = filter.filter(request);
        Assert.assertThat((Object)result.getBaseUri().getScheme(), (Matcher)CoreMatchers.containsString((String)"https"));
    }

    @Test
    public void shouldSetTheRequestUriToTheSameProtocolAsTheXForwardProtoHeader() throws Exception {
        String theProtocol = "https";
        XForwardFilter filter = new XForwardFilter();
        InBoundHeaders headers = new InBoundHeaders();
        headers.add(X_FORWARD_PROTO_HEADER_KEY, (Object)"https");
        ContainerRequest request = new ContainerRequest((WebApplication)Mockito.mock(WebApplication.class), "GET", URI.create("http://jimwebber.org:1234"), URI.create("http://jimwebber.org:1234/foo/bar"), headers, (InputStream)Mockito.mock(InputStream.class));
        ContainerRequest result = filter.filter(request);
        Assert.assertThat((Object)result.getBaseUri().getScheme(), (Matcher)CoreMatchers.containsString((String)"https"));
    }
}

