/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.HTTPLoggingPreparednessRuleTest;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class HTTPLoggingDocIT
extends ExclusiveServerTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        File logDirectory = this.testDirectory.directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        File confDir = this.testDirectory.directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(Configurator.HTTP_LOGGING, "false").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(this.testDirectory.directory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            String query = "?implicitlyDisabled" + this.randomString();
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
            response.close();
            File httpLog = new File(logDirectory, "http.log");
            Assert.assertThat((Object)httpLog.exists(), (Matcher)CoreMatchers.is((Object)false));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        File logDirectory = this.testDirectory.directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        File confDir = this.testDirectory.directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        String query = "?explicitlyEnabled=" + this.randomString();
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(Configurator.HTTP_LOGGING, "true").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(this.testDirectory.directory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertThat((Object)response.getStatus(), (Matcher)CoreMatchers.is((Object)200));
            response.close();
            File httpLog = new File(logDirectory, "http.log");
            org.neo4j.test.Assert.assertEventually((String)"request appears in log", this.fileContentSupplier(httpLog), (Matcher)CoreMatchers.containsString((String)query), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenDebugContentLoggingEnabledShouldLogContent() throws Exception {
        File logDirectory = this.testDirectory.directory("givenDebugContentLoggingEnabledShouldLogContent-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        File confDir = this.testDirectory.directory("givenDebugContentLoggingEnabledShouldLogContent-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory, "$requestContent\n%responseContent"), confDir);
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(Configurator.HTTP_LOGGING, "true").withProperty(Configurator.HTTP_CONTENT_LOGGING, "true").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(this.testDirectory.directory("givenDebugContentLoggingEnabledShouldLogContent-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            HTTP.Response req = HTTP.POST(server.baseUri().resolve("/db/data/node").toString(), HTTP.RawPayload.rawPayload("{\"name\":\"Hello, world!\"}"));
            Assert.assertThat((Object)req.status(), (Matcher)CoreMatchers.is((Object)201));
            File httpLog = new File(logDirectory, "http.log");
            org.neo4j.test.Assert.assertEventually((String)"request appears in log", this.fileContentSupplier(httpLog), (Matcher)CoreMatchers.containsString((String)"Hello, world!"), (long)5L, (TimeUnit)TimeUnit.SECONDS);
            org.neo4j.test.Assert.assertEventually((String)"request appears in log", this.fileContentSupplier(httpLog), (Matcher)CoreMatchers.containsString((String)"metadata"), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void givenConfigurationWithUnwritableLogDirectoryShouldFailToStartServer() throws Exception {
        File confDir = this.testDirectory.directory("confdir");
        File unwritableLogDir = this.createUnwritableDirectory();
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableLogDir), confDir);
        Config config = new Config(MapUtil.stringMap((String[])new String[]{Configurator.HTTP_LOGGING, "true", Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()}));
        this.exception.expect(InvalidSettingException.class);
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withPreflightTasks(new PreflightTask[]{new EnsurePreparedForHttpLogging(config)}).withProperty(Configurator.HTTP_LOGGING, "true").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(confDir.getAbsolutePath()).build();
    }

    private ThrowingSupplier<String, IOException> fileContentSupplier(final File file) {
        return new ThrowingSupplier<String, IOException>(){

            public String get() throws IOException {
                return FileUtils.readTextFile((File)file, (Charset)Charsets.UTF_8);
            }
        };
    }

    private File createUnwritableDirectory() {
        File file;
        if (SystemUtils.IS_OS_WINDOWS) {
            file = new File("\\\\" + this.randomString() + "\\http.log");
        } else {
            file = this.testDirectory.file("unwritable-" + this.randomString());
            Assert.assertThat((String)"create directory to be unwritable", (Object)file.mkdirs(), (Matcher)CoreMatchers.is((Object)true));
            Assume.assumeThat((String)"mark directory as unwritable", (Object)file.setWritable(false, false), (Matcher)CoreMatchers.is((Object)true));
            Assume.assumeThat((String)"directory permissions are respected", (Object)file.canWrite(), (Matcher)CoreMatchers.is((Object)false));
        }
        return file;
    }

    private String randomString() {
        return UUID.randomUUID().toString();
    }
}

