/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;

public class DatabaseTuningPropertyFileBuilder {
    private File parentDirectory = null;
    private String mappedMemory = null;
    private String kernelId;

    public static DatabaseTuningPropertyFileBuilder builder(File directory) {
        return new DatabaseTuningPropertyFileBuilder(directory);
    }

    private DatabaseTuningPropertyFileBuilder(File directory) {
        this.parentDirectory = directory;
    }

    public File build() throws IOException {
        File temporaryConfigFile = new File(this.parentDirectory, "neo4j.properties");
        Map properties = MapUtil.stringMap((String[])new String[]{"neostore.relationshipstore.db.mapped_memory", "50M", "neostore.propertystore.db.mapped_memory", "90M", "neostore.propertystore.db.strings.mapped_memory", "130M", "neostore.propertystore.db.arrays.mapped_memory", "150M"});
        if (this.mappedMemory == null) {
            properties.put("neostore.nodestore.db.mapped_memory", "25M");
        } else {
            properties.put("neostore.nodestore.db.mapped_memory", this.mappedMemory);
        }
        if (this.kernelId != null) {
            properties.put(GraphDatabaseSettings.forced_kernel_id.name(), this.kernelId);
        }
        ServerTestUtils.writePropertiesToFile(properties, temporaryConfigFile);
        return temporaryConfigFile;
    }

    public DatabaseTuningPropertyFileBuilder mappedMemory(int i) {
        this.mappedMemory = String.valueOf(i) + "M";
        return this;
    }

    public DatabaseTuningPropertyFileBuilder withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }
}

