/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.BaseServerConfigLoader;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.ServerSettings;

public class ServerConfigLoaderTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private final Log log = NullLog.getInstance();
    private final BaseServerConfigLoader configLoader = new BaseServerConfigLoader();

    @Test
    public void shouldProvideAConfiguration() throws IOException {
        File configFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        Config config = this.configLoader.loadConfig(null, configFile, this.log, new Pair[0]);
        Assert.assertNotNull((Object)config);
    }

    @Test
    public void shouldUseSpecifiedConfigFile() throws Exception {
        File configFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue("foo", "bar").build();
        Config testConf = this.configLoader.loadConfig(null, configFile, this.log, new Pair[0]);
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", testConf.getParams().get("foo"));
    }

    @Test
    public void shouldAcceptDuplicateKeysWithSameValue() throws IOException {
        File configFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue("foo", "bar").withNameValue("foo", "bar").build();
        Config testConf = this.configLoader.loadConfig(null, configFile, this.log, new Pair[0]);
        Assert.assertNotNull((Object)testConf);
        String EXPECTED_VALUE = "bar";
        Assert.assertEquals((Object)"bar", testConf.getParams().get("foo"));
    }

    @Test
    public void shouldSupportProvidingDatabaseTuningParametersSeparately() throws IOException {
        File databaseTuningPropertyFile = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).withKernelId("kernelfromseparatedbtuningfile").build();
        File propertyFileWithDbTuningProperty = PropertyFileBuilder.builder(this.folder.getRoot()).withDbTuningPropertyFile(databaseTuningPropertyFile).build();
        Config config = this.configLoader.loadConfig(null, propertyFileWithDbTuningProperty, this.log, new Pair[0]);
        Assert.assertNotNull((Object)config);
        Assert.assertEquals((Object)config.get(GraphDatabaseSettings.forced_kernel_id), (Object)"kernelfromseparatedbtuningfile");
    }

    @Test
    public void shouldFindThirdPartyJaxRsPackages() throws IOException {
        File file = ServerTestUtils.createTempPropertyFile(this.folder.getRoot());
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file, true));){
            out.write(Configurator.THIRD_PARTY_PACKAGES_KEY);
            out.write("=");
            out.write("com.foo.bar=\"mount/point/foo\",");
            out.write("com.foo.baz=\"/bar\",");
            out.write("com.foo.foobarbaz=\"/\"");
            out.write(System.lineSeparator());
        }
        Config config = this.configLoader.loadConfig(null, file, this.log, new Pair[0]);
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        Assert.assertNotNull((Object)thirdpartyJaxRsPackages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
    }
}

