/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.integration;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class StartupLoggingIT
extends ExclusiveServerTestBase {
    @Test
    public void shouldLogHelpfulStartupMessages() throws Throwable {
        SuppressOutput suppressed = SuppressOutput.suppressAll();
        suppressed.call((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                CommunityBootstrapper boot = new CommunityBootstrapper();
                CommunityBootstrapper.start((Bootstrapper)boot, (String[])new String[0]);
                boot.stop();
                return null;
            }
        });
        List captured = suppressed.getOutputVoice().lines();
        MatcherAssert.assertThat((Object)captured, StartupLoggingIT.containsAtLeastTheseLines(StartupLoggingIT.warn("Config file \\[config.neo4j-server\\.properties\\] does not exist."), StartupLoggingIT.warn("Config file \\[config.neo4j\\.properties\\] does not exist."), StartupLoggingIT.info("Successfully started database"), StartupLoggingIT.info("Starting HTTP on port 7474 \\(.+ threads available\\)"), StartupLoggingIT.info("Mounting static content at /webadmin"), StartupLoggingIT.info("Mounting static content at /browser"), StartupLoggingIT.info("Remote interface ready and available at http://.+:7474/"), StartupLoggingIT.info("Successfully shutdown Neo4j Server"), StartupLoggingIT.info("Successfully stopped database"), StartupLoggingIT.info("Successfully shutdown database"), StartupLoggingIT.info("Successfully shutdown Neo Server on port \\[.+\\], database \\[.+\\]")));
    }

    public static Matcher<List<String>> containsAtLeastTheseLines(final Matcher<String> ... expectedLinePatterns) {
        return new TypeSafeMatcher<List<String>>(){

            protected boolean matchesSafely(List<String> lines) {
                if (expectedLinePatterns.length > lines.size()) {
                    return false;
                }
                int e = 0;
                for (int i = 0; i < lines.size(); ++i) {
                    boolean matches;
                    String line = lines.get(i);
                    while (!(matches = expectedLinePatterns[e].matches((Object)line))) {
                        if (++i >= lines.size()) {
                            return false;
                        }
                        line = lines.get(i);
                    }
                    ++e;
                    if (matches) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendList("", "\n", "", Arrays.asList(expectedLinePatterns));
            }
        };
    }

    public static Matcher<String> info(String messagePattern) {
        return StartupLoggingIT.line("INFO", messagePattern);
    }

    public static Matcher<String> warn(String messagePattern) {
        return StartupLoggingIT.line("WARN", messagePattern);
    }

    public static Matcher<String> line(final String level, final String messagePattern) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String line) {
                return line.matches(".*" + level + "\\s+" + messagePattern);
            }

            public void describeTo(Description description) {
                description.appendText(level).appendText(" ").appendText(messagePattern);
            }
        };
    }
}

