/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.util.concurrent.Callable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.KernelData;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.TestData;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class CommunityVersionAndEditionServiceDocIT
extends ExclusiveServerTestBase {
    private static NeoServer server;
    private static FunctionalTestHelper functionalTestHelper;
    @ClassRule
    public static TemporaryFolder staticFolder;
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);
    private static FakeClock clock;

    @Before
    public void setUp() {
        ((RESTDocsGenerator)((Object)this.gen.get())).setSection("dev/rest-api/database-version");
    }

    @BeforeClass
    public static void setupServer() throws Exception {
        clock = new FakeClock();
        server = CommunityServerBuilder.server().usingDatabaseDir(staticFolder.getRoot().getAbsolutePath()).withClock((Clock)clock).build();
        SuppressOutput.suppressAll().call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                server.start();
                return null;
            }
        });
        functionalTestHelper = new FunctionalTestHelper(server);
    }

    @Before
    public void setupTheDatabase() throws Exception {
    }

    @AfterClass
    public static void stopServer() throws Exception {
        SuppressOutput.suppressAll().call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                server.stop();
                return null;
            }
        });
    }

    @Test
    public void shouldReportCommunityEdition() throws Exception {
        String releaseVersion = ((KernelData)server.getDatabase().getGraph().getDependencyResolver().resolveDependency(KernelData.class)).version().getReleaseVersion();
        HTTP.Response res = HTTP.GET(functionalTestHelper.managementUri() + "/" + "server/version");
        Assert.assertEquals((long)200L, (long)res.status());
        Assert.assertThat((Object)res.get("edition").asText(), (Matcher)Matchers.equalTo((Object)"community"));
        Assert.assertThat((Object)res.get("version").asText(), (Matcher)Matchers.equalTo((Object)releaseVersion));
    }

    static {
        staticFolder = new TemporaryFolder();
    }
}

