/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ConfigWrappingConfiguration;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginLifecycle;
import org.neo4j.server.plugins.SPIPluginLifecycle;

public class ExtensionInitializer {
    private final Iterable<PluginLifecycle> lifecycles;
    private final NeoServer neoServer;

    public ExtensionInitializer(NeoServer neoServer) {
        this.neoServer = neoServer;
        this.lifecycles = Service.load(PluginLifecycle.class);
    }

    public Collection<Injectable<?>> initializePackages(Iterable<String> packageNames) {
        GraphDatabaseAPI graphDatabaseService = this.neoServer.getDatabase().getGraph();
        Config configuration = this.neoServer.getConfig();
        HashSet injectables = new HashSet();
        for (PluginLifecycle lifecycle : this.lifecycles) {
            if (!this.hasPackage(lifecycle, packageNames)) continue;
            if (lifecycle instanceof SPIPluginLifecycle) {
                SPIPluginLifecycle lifeCycleSpi = (SPIPluginLifecycle)lifecycle;
                injectables.addAll(lifeCycleSpi.start(this.neoServer));
                continue;
            }
            injectables.addAll(lifecycle.start((GraphDatabaseService)graphDatabaseService, (Configuration)new ConfigWrappingConfiguration(configuration)));
        }
        return injectables;
    }

    private boolean hasPackage(PluginLifecycle pluginLifecycle, Iterable<String> packageNames) {
        String lifecyclePackageName = pluginLifecycle.getClass().getPackage().getName();
        for (String packageName : packageNames) {
            if (!lifecyclePackageName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        for (PluginLifecycle pluginLifecycle : this.lifecycles) {
            pluginLifecycle.stop();
        }
    }
}

