/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.Collection;
import java.util.Map;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.rest.domain.EndNodeNotFoundException;
import org.neo4j.server.rest.domain.StartNodeNotFoundException;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.BadInputException;
import org.neo4j.server.rest.repr.ConstraintDefinitionRepresentation;
import org.neo4j.server.rest.repr.IndexDefinitionRepresentation;
import org.neo4j.server.rest.repr.IndexRepresentation;
import org.neo4j.server.rest.repr.IndexedEntityRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.PathRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rest.web.NoSuchPropertyException;
import org.neo4j.server.rest.web.NodeNotFoundException;
import org.neo4j.server.rest.web.PropertyValueException;
import org.neo4j.server.rest.web.RelationshipNotFoundException;

public class TransactionWrappedDatabaseActions
extends DatabaseActions {
    private final GraphDatabaseAPI graph;

    public TransactionWrappedDatabaseActions(LeaseManager leaseManager, GraphDatabaseAPI graph) {
        super(leaseManager, graph);
        this.graph = graph;
    }

    public NodeRepresentation createNode(Map<String, Object> properties, Label ... labels) throws PropertyValueException {
        try (Transaction transaction = this.graph.beginTx();){
            NodeRepresentation nodeRepresentation = super.createNode(properties, labels);
            transaction.success();
            NodeRepresentation nodeRepresentation2 = nodeRepresentation;
            return nodeRepresentation2;
        }
    }

    public NodeRepresentation getNode(long nodeId) throws NodeNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            NodeRepresentation node = super.getNode(nodeId);
            transaction.success();
            NodeRepresentation nodeRepresentation = node;
            return nodeRepresentation;
        }
    }

    public void deleteNode(long nodeId) throws NodeNotFoundException, ConstraintViolationException {
        try (Transaction transaction = this.graph.beginTx();){
            super.deleteNode(nodeId);
            transaction.success();
        }
    }

    public void setNodeProperty(long nodeId, String key, Object value) throws PropertyValueException, NodeNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            super.setNodeProperty(nodeId, key, value);
            transaction.success();
        }
    }

    public void removeNodeProperty(long nodeId, String key) throws NodeNotFoundException, NoSuchPropertyException {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeNodeProperty(nodeId, key);
            transaction.success();
        }
    }

    public void setAllNodeProperties(long nodeId, Map<String, Object> properties) throws PropertyValueException, NodeNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            super.setAllNodeProperties(nodeId, properties);
            transaction.success();
        }
    }

    public void removeAllNodeProperties(long nodeId) throws NodeNotFoundException, PropertyValueException {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeAllNodeProperties(nodeId);
            transaction.success();
        }
    }

    public void addLabelToNode(long nodeId, Collection<String> labelNames) throws NodeNotFoundException, BadInputException {
        try (Transaction transaction = this.graph.beginTx();){
            super.addLabelToNode(nodeId, labelNames);
            transaction.success();
        }
    }

    public void removeLabelFromNode(long nodeId, String labelName) throws NodeNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeLabelFromNode(nodeId, labelName);
            transaction.success();
        }
    }

    public IndexRepresentation createNodeIndex(Map<String, Object> indexSpecification) {
        try (Transaction transaction = this.graph.beginTx();){
            IndexRepresentation indexRepresentation = super.createNodeIndex(indexSpecification);
            transaction.success();
            IndexRepresentation indexRepresentation2 = indexRepresentation;
            return indexRepresentation2;
        }
    }

    public RelationshipRepresentation createRelationship(long startNodeId, long endNodeId, String type, Map<String, Object> properties) throws StartNodeNotFoundException, EndNodeNotFoundException, PropertyValueException {
        try (Transaction transaction = this.graph.beginTx();){
            RelationshipRepresentation relationshipRepresentation = super.createRelationship(startNodeId, endNodeId, type, properties);
            transaction.success();
            RelationshipRepresentation relationshipRepresentation2 = relationshipRepresentation;
            return relationshipRepresentation2;
        }
    }

    public RelationshipRepresentation getRelationship(long relationshipId) throws RelationshipNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            RelationshipRepresentation relationship = super.getRelationship(relationshipId);
            transaction.success();
            RelationshipRepresentation relationshipRepresentation = relationship;
            return relationshipRepresentation;
        }
    }

    public void deleteRelationship(long relationshipId) throws RelationshipNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            super.deleteRelationship(relationshipId);
            transaction.success();
        }
    }

    public ListRepresentation getNodeRelationships(long nodeId, DatabaseActions.RelationshipDirection direction, Collection<String> types) throws NodeNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            ListRepresentation nodeRelationships = super.getNodeRelationships(nodeId, direction, types);
            transaction.success();
            ListRepresentation listRepresentation = nodeRelationships;
            return listRepresentation;
        }
    }

    public void setAllRelationshipProperties(long relationshipId, Map<String, Object> properties) throws PropertyValueException, RelationshipNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            super.setAllRelationshipProperties(relationshipId, properties);
            transaction.success();
        }
    }

    public void setRelationshipProperty(long relationshipId, String key, Object value) throws PropertyValueException, RelationshipNotFoundException {
        try (Transaction transaction = this.graph.beginTx();){
            super.setRelationshipProperty(relationshipId, key, value);
            transaction.success();
        }
    }

    public void removeAllRelationshipProperties(long relationshipId) throws RelationshipNotFoundException, PropertyValueException {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeAllRelationshipProperties(relationshipId);
            transaction.success();
        }
    }

    public void removeRelationshipProperty(long relationshipId, String key) throws RelationshipNotFoundException, NoSuchPropertyException {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeRelationshipProperty(relationshipId, key);
            transaction.success();
        }
    }

    public IndexedEntityRepresentation addToNodeIndex(String indexName, String key, String value, long nodeId) {
        try (Transaction transaction = this.graph.beginTx();){
            IndexedEntityRepresentation indexedEntityRepresentation = super.addToNodeIndex(indexName, key, value, nodeId);
            transaction.success();
            IndexedEntityRepresentation indexedEntityRepresentation2 = indexedEntityRepresentation;
            return indexedEntityRepresentation2;
        }
    }

    public void removeFromNodeIndex(String indexName, String key, String value, long id) {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeFromNodeIndex(indexName, key, value, id);
            transaction.success();
        }
    }

    public void removeFromNodeIndexNoValue(String indexName, String key, long id) {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeFromNodeIndexNoValue(indexName, key, id);
            transaction.success();
        }
    }

    public void removeFromNodeIndexNoKeyValue(String indexName, long id) {
        try (Transaction transaction = this.graph.beginTx();){
            super.removeFromNodeIndexNoKeyValue(indexName, id);
            transaction.success();
        }
    }

    public PathRepresentation findSinglePath(long startId, long endId, Map<String, Object> map) {
        try (Transaction transaction = this.graph.beginTx();){
            PathRepresentation singlePath = super.findSinglePath(startId, endId, map);
            transaction.success();
            PathRepresentation pathRepresentation = singlePath;
            return pathRepresentation;
        }
    }

    public ListRepresentation getNodesWithLabel(String labelName, Map<String, Object> properties) {
        try (Transaction transaction = this.graph.beginTx();){
            ListRepresentation nodesWithLabel = super.getNodesWithLabel(labelName, properties);
            transaction.success();
            ListRepresentation listRepresentation = nodesWithLabel;
            return listRepresentation;
        }
    }

    public IndexDefinitionRepresentation createSchemaIndex(String labelName, Iterable<String> propertyKey) {
        try (Transaction transaction = this.graph.beginTx();){
            IndexDefinitionRepresentation indexDefinitionRepresentation = super.createSchemaIndex(labelName, propertyKey);
            transaction.success();
            IndexDefinitionRepresentation indexDefinitionRepresentation2 = indexDefinitionRepresentation;
            return indexDefinitionRepresentation2;
        }
    }

    public boolean dropSchemaIndex(String labelName, String propertyKey) {
        try (Transaction transaction = this.graph.beginTx();){
            boolean result = super.dropSchemaIndex(labelName, propertyKey);
            transaction.success();
            boolean bl = result;
            return bl;
        }
    }

    public ConstraintDefinitionRepresentation createPropertyUniquenessConstraint(String labelName, Iterable<String> propertyKeys) {
        try (Transaction transaction = this.graph.beginTx();){
            ConstraintDefinitionRepresentation constraintDefinitionRepresentation = super.createPropertyUniquenessConstraint(labelName, propertyKeys);
            transaction.success();
            ConstraintDefinitionRepresentation constraintDefinitionRepresentation2 = constraintDefinitionRepresentation;
            return constraintDefinitionRepresentation2;
        }
    }

    public boolean dropPropertyUniquenessConstraint(String labelName, Iterable<String> propertyKeys) {
        try (Transaction transaction = this.graph.beginTx();){
            boolean result = super.dropPropertyUniquenessConstraint(labelName, propertyKeys);
            transaction.success();
            boolean bl = result;
            return bl;
        }
    }

    public boolean dropNodePropertyExistenceConstraint(String labelName, Iterable<String> propertyKeys) {
        try (Transaction transaction = this.graph.beginTx();){
            boolean result = super.dropNodePropertyExistenceConstraint(labelName, propertyKeys);
            transaction.success();
            boolean bl = result;
            return bl;
        }
    }

    public boolean dropRelationshipPropertyExistenceConstraint(String typeName, Iterable<String> propertyKeys) {
        try (Transaction transaction = this.graph.beginTx();){
            boolean result = super.dropRelationshipPropertyExistenceConstraint(typeName, propertyKeys);
            transaction.success();
            boolean bl = result;
            return bl;
        }
    }
}

