/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.server.configuration.BaseServerConfigLoader;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.web.ServerInternalSettings;

public class PropertyFileConfigurator
implements ConfigurationBuilder {
    private final Config serverConfig;
    private Map<String, String> databaseTuningProperties;
    private Map<String, String> serverProperties;

    public PropertyFileConfigurator(File propertiesFile, Log log) {
        if (propertiesFile == null) {
            throw new IllegalArgumentException("propertiesFile cannot be null ");
        }
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null ");
        }
        this.loadServerProperties(propertiesFile, log);
        this.loadDatabaseTuningProperties(propertiesFile, log);
        this.serverConfig = new Config(this.serverProperties, BaseServerConfigLoader.getDefaultSettingsClasses());
    }

    @Override
    public Config configuration() {
        return this.serverConfig == null ? new Config() : this.serverConfig;
    }

    @Override
    public Map<String, String> getDatabaseTuningProperties() {
        return this.databaseTuningProperties == null ? new HashMap() : this.databaseTuningProperties;
    }

    private void loadDatabaseTuningProperties(File configFile, Log log) {
        File databaseTuningPropertyFile;
        String databaseTuningPropertyPath = this.serverProperties.get(ServerInternalSettings.legacy_db_config.name());
        if (databaseTuningPropertyPath == null) {
            databaseTuningPropertyPath = configFile.getParent() + File.separator + "neo4j.properties";
            this.serverProperties.put(ServerInternalSettings.legacy_db_config.name(), databaseTuningPropertyPath);
            log.warn("No database tuning file explicitly set, defaulting to [%s]", new Object[]{databaseTuningPropertyPath});
        }
        if (!(databaseTuningPropertyFile = new File(databaseTuningPropertyPath)).exists()) {
            log.warn("The specified file for database performance tuning properties [%s] does not exist.", new Object[]{databaseTuningPropertyPath});
        } else {
            try {
                this.databaseTuningProperties = MapUtil.load((File)databaseTuningPropertyFile);
            }
            catch (IOException e) {
                log.warn("Unable to load database tuning file: " + e.getMessage());
            }
        }
        if (this.databaseTuningProperties == null) {
            this.databaseTuningProperties = new HashMap<String, String>();
        }
    }

    private void loadServerProperties(File serverConfigFile, Log log) {
        if (serverConfigFile == null) {
            serverConfigFile = new File(System.getProperty("org.neo4j.server.properties", "config/neo4j-server.properties"));
        }
        if (!serverConfigFile.exists()) {
            log.warn("The specified file for server configuration [%s] does not exist. Using the default non-user-defined server configuration.", new Object[]{serverConfigFile.getAbsoluteFile()});
        } else {
            try {
                this.serverProperties = MapUtil.load((File)serverConfigFile);
            }
            catch (IOException e) {
                log.warn("Unable to load server configuration file: " + e.getMessage());
            }
        }
        if (this.serverProperties == null) {
            this.serverProperties = new HashMap<String, String>();
        }
    }
}

