/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.SuppressOutput;

public class TestLifecycleManagedDatabase {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final AssertableLogProvider logProvider = new AssertableLogProvider();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule((LogProvider)this.logProvider);
    private File databaseDirectory;
    private Database theDatabase;
    private boolean deletionFailureOk;
    private LifecycleManagingDatabase.GraphFactory dbFactory;

    @Before
    public void setup() throws Exception {
        this.databaseDirectory = ServerTestUtils.createTempDir();
        this.dbFactory = (LifecycleManagingDatabase.GraphFactory)Mockito.mock(LifecycleManagingDatabase.GraphFactory.class);
        Mockito.when((Object)this.dbFactory.newGraphDatabase((Config)org.mockito.Matchers.any(Config.class), (GraphDatabaseFacadeFactory.Dependencies)org.mockito.Matchers.any(GraphDatabaseFacadeFactory.Dependencies.class))).thenReturn((Object)this.dbRule.getGraphDatabaseAPI());
        this.theDatabase = this.newDatabase();
    }

    private LifecycleManagingDatabase newDatabase() {
        Config dbConfig = new Config(MapUtil.stringMap((String[])new String[]{ServerInternalSettings.legacy_db_location.name(), this.databaseDirectory.getAbsolutePath()}));
        return new LifecycleManagingDatabase(dbConfig, this.dbFactory, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)this.logProvider));
    }

    @After
    public void shutdownDatabase() throws Throwable {
        block2: {
            this.theDatabase.stop();
            try {
                FileUtils.forceDelete((File)this.databaseDirectory);
            }
            catch (IOException e) {
                if (this.deletionFailureOk) break block2;
                throw e;
            }
        }
    }

    @Test
    public void shouldLogOnSuccessfulStartup() throws Throwable {
        this.theDatabase.start();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(LifecycleManagingDatabase.class).info("Successfully started database")});
    }

    @Test
    public void shouldShutdownCleanly() throws Throwable {
        this.theDatabase.start();
        this.theDatabase.stop();
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(LifecycleManagingDatabase.class).info("Successfully stopped database")});
    }

    @Test
    public void shouldComplainIfDatabaseLocationIsAlreadyInUse() throws Throwable {
        this.deletionFailureOk = true;
        this.theDatabase.start();
        LifecycleManagingDatabase db = this.newDatabase();
        try {
            db.start();
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getCause().getCause(), (Matcher)IsInstanceOf.instanceOf(StoreLockException.class));
        }
    }

    @Test
    public void shouldBeAbleToGetLocation() throws Throwable {
        this.theDatabase.start();
        Assert.assertThat((Object)this.theDatabase.getLocation(), (Matcher)Matchers.is((Object)this.databaseDirectory.getAbsolutePath()));
    }
}

