/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.concurrent.RecentK;
import org.neo4j.server.rest.web.CollectUserAgentFilter;
import org.neo4j.test.SuppressOutput;

public class CollectUserAgentFilterTest {
    private final RecentK<String> agents = new RecentK(10);
    private final FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
    private final CollectUserAgentFilter filter = new CollectUserAgentFilter(this.agents);
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldRecordASingleUserAgent() throws IOException, ServletException {
        this.filter.doFilter(CollectUserAgentFilterTest.request("the-agent"), null, this.filterChain);
        Assert.assertThat((Object)this.agents.recentItems(), (Matcher)org.hamcrest.Matchers.hasItem((Object)"the-agent"));
    }

    @Test
    public void shouldOnlyRecordTheFirstFieldOfTheUserAgentString() throws IOException, ServletException {
        this.filter.doFilter(CollectUserAgentFilterTest.request("the-agent other-info"), null, this.filterChain);
        Assert.assertThat((Object)this.agents.recentItems(), (Matcher)org.hamcrest.Matchers.hasItem((Object)"the-agent"));
    }

    @Test
    public void shouldRecordMultipleUserAgents() throws IOException, ServletException {
        this.filter.doFilter(CollectUserAgentFilterTest.request("agent1"), null, this.filterChain);
        this.filter.doFilter(CollectUserAgentFilterTest.request("agent2"), null, this.filterChain);
        Assert.assertThat((Object)this.agents.recentItems(), (Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"agent1", "agent2"}));
    }

    @Test
    public void shouldNotReportDuplicates() throws IOException, ServletException {
        this.filter.doFilter(CollectUserAgentFilterTest.request("the-agent"), null, this.filterChain);
        this.filter.doFilter(CollectUserAgentFilterTest.request("the-agent"), null, this.filterChain);
        Assert.assertThat((Object)this.agents.recentItems(), (Matcher)org.hamcrest.Matchers.hasSize((int)1));
    }

    @Test
    public void shouldCopeIfThereIsNoUserAgentHeader() throws IOException, ServletException {
        this.filter.doFilter(CollectUserAgentFilterTest.request(null), null, this.filterChain);
        Assert.assertThat((Object)this.agents.recentItems(), (Matcher)org.hamcrest.Matchers.hasSize((int)0));
    }

    @Test
    public void shouldSwallowAnyExceptionsThrownByTheRequest() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.stub((Object)request.getHeader(Matchers.anyString())).toThrow((Throwable)new RuntimeException());
        this.filter.doFilter((ServletRequest)request, null, this.filterChain);
    }

    @Test
    public void shouldReturnTheRequest() throws IOException, ServletException {
        ServletRequest original = CollectUserAgentFilterTest.request("the-agent");
        this.filter.doFilter(original, null, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter(original, null);
    }

    private static ServletRequest request(String userAgent) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getHeader("User-Agent")).thenReturn((Object)userAgent);
        return request;
    }
}

