/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.state.NeoStoresSupplier;
import org.neo4j.server.rrd.sampler.PropertyCountSampleable;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class PropertyCountSampleableTest {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();
    public PropertyCountSampleable sampleable;

    @Test
    public void emptyDbHasZeroNodesInUse() {
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void addANodeWithPropertyAndSampleableGoesUp() {
        this.createNodeWithProperty();
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)1.0));
    }

    @Test
    public void addOnlyPropertiesAndSampleableGoesUp() {
        long nodeId = this.createNodeWithProperty();
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)1.0));
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Node node = db.getNodeById(nodeId);
            node.setProperty("id", (Object)UUID.randomUUID().toString());
            tx.success();
        }
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)2.0));
    }

    @Before
    public void setupReferenceNode() {
        DependencyResolver dependencyResolver = this.dbRule.getGraphDatabaseAPI().getDependencyResolver();
        NeoStoresSupplier neoStore = (NeoStoresSupplier)dependencyResolver.resolveDependency(NeoStoresSupplier.class);
        AvailabilityGuard gaurd = (AvailabilityGuard)dependencyResolver.resolveDependency(AvailabilityGuard.class);
        this.sampleable = new PropertyCountSampleable(neoStore, gaurd);
    }

    private long createNodeWithProperty() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            Node n = db.createNode();
            n.setProperty("monkey", (Object)"rock!");
            tx.success();
            long l = n.getId();
            return l;
        }
    }
}

