/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.ssl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.server.security.ssl.Certificates;
import org.neo4j.test.TargetDirectory;

public class CertificatesIT {
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void createSelfSignedCertificate() throws Exception {
        Assume.assumeTrue((!SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0);
        Certificates certificates = new Certificates();
        certificates.createSelfSignedCertificate(this.testDirectory.file("certificate"), this.testDirectory.file("privateKey"), "localhost");
        PosixFileAttributes certificateAttributes = Files.getFileAttributeView(this.testDirectory.file("certificate").toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        Assert.assertTrue((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.OWNER_READ));
        Assert.assertTrue((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.OWNER_WRITE));
        Assert.assertFalse((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.OWNER_EXECUTE));
        Assert.assertFalse((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.GROUP_READ));
        Assert.assertFalse((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.GROUP_WRITE));
        Assert.assertFalse((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.GROUP_EXECUTE));
        Assert.assertFalse((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.OTHERS_READ));
        Assert.assertFalse((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.OTHERS_WRITE));
        Assert.assertFalse((boolean)certificateAttributes.permissions().contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        PosixFileAttributes privateKey = Files.getFileAttributeView(this.testDirectory.file("privateKey").toPath(), PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        Assert.assertTrue((boolean)privateKey.permissions().contains((Object)PosixFilePermission.OWNER_READ));
        Assert.assertTrue((boolean)privateKey.permissions().contains((Object)PosixFilePermission.OWNER_WRITE));
        Assert.assertFalse((boolean)privateKey.permissions().contains((Object)PosixFilePermission.OWNER_EXECUTE));
        Assert.assertFalse((boolean)privateKey.permissions().contains((Object)PosixFilePermission.GROUP_READ));
        Assert.assertFalse((boolean)privateKey.permissions().contains((Object)PosixFilePermission.GROUP_WRITE));
        Assert.assertFalse((boolean)privateKey.permissions().contains((Object)PosixFilePermission.GROUP_EXECUTE));
        Assert.assertFalse((boolean)privateKey.permissions().contains((Object)PosixFilePermission.OTHERS_READ));
        Assert.assertFalse((boolean)privateKey.permissions().contains((Object)PosixFilePermission.OTHERS_WRITE));
        Assert.assertFalse((boolean)privateKey.permissions().contains((Object)PosixFilePermission.OTHERS_EXECUTE));
    }
}

