/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.GqlException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.Neo4jError;

/**
 * TransactionLifecycleExceptions are internal exceptions that may be thrown
 * due to server transaction lifecycle transitions that map directly on a
 * {@link Status.Code}.
 */
abstract class TransactionLifecycleException extends GqlException {
    protected TransactionLifecycleException(String message) {
        super(message);
    }

    protected TransactionLifecycleException(ErrorGqlStatusObject gql, String message) {
        super(gql, message);
    }

    protected TransactionLifecycleException(String message, Throwable cause) {
        super(message, cause);
    }

    protected TransactionLifecycleException(ErrorGqlStatusObject gql, String message, Throwable cause) {
        super(gql, message, cause);
    }

    Neo4jError toNeo4jError() {
        return new Neo4jError(getStatusCode(), this);
    }

    protected abstract Status getStatusCode();
}
