/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.log4j.LoggerTarget;
import org.neo4j.util.concurrent.AsyncEvents;

public class RotatingRequestLog
extends AbstractLifeCycle
implements RequestLog,
AsyncEvents.Monitor {
    private final InternalLog log;

    public RotatingRequestLog(InternalLogProvider logProvider) {
        this.log = logProvider.getLog(LoggerTarget.HTTP_LOGGER);
    }

    public void log(Request request, Response response) {
        String remoteHost = RotatingRequestLog.swallowExceptions(request, Request::getRemoteAddr);
        String user = RotatingRequestLog.swallowExceptions(request, Request::getId);
        String requestURL = RotatingRequestLog.findRequestURI(request);
        int statusCode = response.getStatus();
        long length = Response.getContentBytesWritten((Response)response);
        String referer = RotatingRequestLog.swallowExceptions(request, r -> r.getHeaders().get("Referer"));
        String userAgent = RotatingRequestLog.swallowExceptions(request, r -> r.getHeaders().get("User-Agent"));
        long requestTimeStamp = request != null ? Request.getTimeStamp((Request)request) : -1L;
        long now = System.currentTimeMillis();
        long serviceTime = requestTimeStamp < 0L ? -1L : now - requestTimeStamp;
        this.log.info("%s - %s [%tc] \"%s\" %s %s \"%s\" \"%s\" %s", new Object[]{StringUtils.defaultString((String)remoteHost), StringUtils.defaultString((String)user), now, StringUtils.defaultString((String)requestURL), statusCode, length, StringUtils.defaultString((String)referer), StringUtils.defaultString((String)userAgent), serviceTime});
    }

    private static <T> T swallowExceptions(Request outerRequest, Function<Request, T> function) {
        try {
            return outerRequest == null ? null : (T)function.apply(outerRequest);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void eventCount(long count) {
    }

    private static String findRequestURI(Request request) {
        HttpURI requestURI = RotatingRequestLog.swallowExceptions(request, Request::getHttpURI);
        if (requestURI != null) {
            return requestURI.asString();
        }
        return "";
    }
}

