/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundHelper;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.server.http.cypher.HttpTransactionManager;
import org.neo4j.server.http.cypher.TransactionFacade;
import org.neo4j.time.Clocks;

class HttpTransactionManagerTest {
    HttpTransactionManagerTest() {
    }

    @Test
    void shouldSetupJobScheduler() {
        DatabaseManagementService managementService = (DatabaseManagementService)Mockito.mock(DatabaseManagementService.class);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        new HttpTransactionManager(managementService, (MemoryPool)Mockito.mock(MemoryPool.class), jobScheduler, Clocks.systemClock(), Duration.ofMinutes(1L), (InternalLogProvider)logProvider, transactionManager, authManager, false);
        long runEvery = Math.round((double)Duration.ofMinutes(1L).toMillis() / 2.0);
        ((JobScheduler)Mockito.verify((Object)jobScheduler)).scheduleRecurring((Group)ArgumentMatchers.eq((Object)Group.SERVER_TRANSACTION_TIMEOUT), (JobMonitoringParams)ArgumentMatchers.any(JobMonitoringParams.class), (Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)runEvery), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    void shouldCreateTransactionHandleRegistry() {
        DatabaseManagementService managementService = (DatabaseManagementService)Mockito.mock(DatabaseManagementService.class);
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        HttpTransactionManager manager = new HttpTransactionManager(managementService, (MemoryPool)Mockito.mock(MemoryPool.class), jobScheduler, Clocks.systemClock(), Duration.ofMinutes(1L), (InternalLogProvider)logProvider, transactionManager, authManager, false);
        Assertions.assertNotNull((Object)manager.getTransactionRegistry());
    }

    @Test
    void shouldGetEmptyTransactionFacadeOfDatabaseData() {
        DatabaseManagementService managementService = (DatabaseManagementService)Mockito.mock(DatabaseManagementService.class);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        HttpTransactionManager manager = HttpTransactionManagerTest.newTransactionManager(managementService, memoryPool);
        Optional graphDatabaseFacade = manager.getGraphDatabaseAPI("data");
        Assertions.assertFalse((boolean)graphDatabaseFacade.isPresent());
        ((DatabaseManagementService)Mockito.verify((Object)managementService)).database("data");
    }

    @Test
    void shouldGetTransactionFacadeOfDatabaseWithSpecifiedName() {
        DatabaseManagementService managementService = (DatabaseManagementService)Mockito.mock(DatabaseManagementService.class);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        HttpTransactionManager manager = HttpTransactionManagerTest.newTransactionManager(managementService, memoryPool);
        Optional transactionFacade = manager.getGraphDatabaseAPI("neo4j");
        Assertions.assertTrue((boolean)transactionFacade.isPresent());
        ((DatabaseManagementService)Mockito.verify((Object)managementService)).database("neo4j");
    }

    @Test
    void shouldGetEmptyTransactionFacadeForUnknownDatabase() {
        DatabaseManagementService managementService = (DatabaseManagementService)Mockito.mock(DatabaseManagementService.class);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        HttpTransactionManager manager = HttpTransactionManagerTest.newTransactionManager(managementService, memoryPool);
        Optional transactionFacade = manager.getGraphDatabaseAPI("foo");
        Assertions.assertFalse((boolean)transactionFacade.isPresent());
        ((DatabaseManagementService)Mockito.verify((Object)managementService)).database("foo");
    }

    @Test
    void shouldCreateTransactionFacade() {
        DatabaseManagementService managementService = (DatabaseManagementService)Mockito.mock(DatabaseManagementService.class);
        GraphDatabaseAPI graphDatabase = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
        MemoryPool memoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        MemoryTracker memoryTracker = (MemoryTracker)Mockito.mock(MemoryTracker.class);
        HttpTransactionManager manager = HttpTransactionManagerTest.newTransactionManager(managementService, memoryPool);
        Mockito.when((Object)graphDatabase.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        Mockito.when((Object)graphDatabase.dbmsInfo()).thenReturn((Object)DbmsInfo.ENTERPRISE);
        Mockito.when((Object)((QueryExecutionEngine)dependencyResolver.resolveDependency(QueryExecutionEngine.class))).thenReturn((Object)queryExecutionEngine);
        TransactionFacade facade = manager.createTransactionFacade(graphDatabase, memoryTracker, "neo4j");
        ((MemoryTracker)Mockito.verify((Object)memoryTracker)).allocateHeap(TransactionFacade.SHALLOW_SIZE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{memoryTracker});
        Assertions.assertNotNull((Object)facade);
    }

    private static HttpTransactionManager newTransactionManager(DatabaseManagementService managementService, MemoryPool memoryPool) {
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        String defaultDatabase = "neo4j";
        Mockito.when((Object)managementService.database((String)ArgumentMatchers.any(String.class))).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            String db = (String)args[0];
            if (db.equals(defaultDatabase) || db.equals("system")) {
                return HttpTransactionManagerTest.graphWithName(db);
            }
            throw DatabaseNotFoundHelper.databaseNotFound((String)db);
        });
        return new HttpTransactionManager(managementService, memoryPool, jobScheduler, Clocks.systemClock(), Duration.ofMinutes(1L), (InternalLogProvider)logProvider, transactionManager, authManager, false);
    }

    private static GraphDatabaseFacade graphWithName(String name) {
        GraphDatabaseFacade graph = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
        Mockito.when((Object)graph.databaseName()).thenReturn((Object)name);
        Mockito.when((Object)graph.getDependencyResolver()).thenReturn((Object)((DependencyResolver)Mockito.mock(DependencyResolver.class, (Answer)Answers.RETURNS_SMART_NULLS)));
        return graph;
    }
}

