/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.neo4j.server.http.cypher;

import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

class InvalidTransactionId extends TransactionLifecycleException {
    private InvalidTransactionId(ErrorGqlStatusObject gqlStatusObject) {
        super(gqlStatusObject, "Unrecognized transaction id. Transaction may have timed out and been rolled back.");
    }

    public static InvalidTransactionId transactionDoesNotExists(long transactionId) {
        return new InvalidTransactionId(ErrorGqlStatusObjectImplementation.from(GqlStatusInfoCodes.STATUS_25N04)
                .withParam(GqlParams.StringParam.transactionId, String.valueOf(transactionId))
                .build());
    }

    @Override
    protected Status getStatusCode() {
        return Status.Transaction.TransactionNotFound;
    }
}
