/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr.formats;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationBasedMessageBodyWriter;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ServerListRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.neo4j.server.rest.repr.formats.JsonFormat;

class JsonFormatTest {
    private JsonFormat json;

    JsonFormatTest() {
    }

    @BeforeEach
    void createOutputFormat() {
        this.json = new JsonFormat();
    }

    @Test
    void canFormatString() throws URISyntaxException {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)ValueRepresentation.string((String)"expected value"), (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        Assertions.assertEquals((Object)"\"expected value\"", (Object)entity);
    }

    @Test
    void canFormatListOfStrings() throws URISyntaxException {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)ListRepresentation.strings((String[])new String[]{"hello", "world"}), (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        String expectedString = JsonHelper.createJsonFrom(Arrays.asList("hello", "world"));
        Assertions.assertEquals((Object)expectedString, (Object)entity);
    }

    @Test
    void canFormatInteger() throws URISyntaxException {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)ValueRepresentation.number((int)10), (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        Assertions.assertEquals((Object)"10", (Object)entity);
    }

    @Test
    void canFormatEmptyObject() throws URISyntaxException {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)new MappingRepresentation(this, "empty"){

            protected void serialize(MappingSerializer serializer) {
            }
        }, (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.emptyMap()), (Object)entity);
    }

    @Test
    void canFormatObjectWithStringField() throws URISyntaxException {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)new MappingRepresentation(this, "string"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putString("key", "expected string");
            }
        }, (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("key", "expected string")), (Object)entity);
    }

    @Test
    void canFormatObjectWithUriField() throws URISyntaxException {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)new MappingRepresentation(this, "uri"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putRelativeUri("URL", "subpath");
            }
        }, (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("URL", "http://localhost/subpath")), (Object)entity);
    }

    @Test
    void canFormatObjectWithNestedObject() throws URISyntaxException {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)new MappingRepresentation(this, "nesting"){

            protected void serialize(MappingSerializer serializer) {
                serializer.putMapping("nested", new MappingRepresentation(this, "data"){

                    protected void serialize(MappingSerializer nested) {
                        nested.putString("data", "expected data");
                    }
                });
            }
        }, (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        Assertions.assertEquals((Object)JsonHelper.createJsonFrom(Collections.singletonMap("nested", Collections.singletonMap("data", "expected data"))), (Object)entity);
    }

    @Test
    void canFormatNestedMapsAndLists() throws Exception {
        String entity = RepresentationBasedMessageBodyWriter.serialize((Representation)new MappingRepresentation(this, "test"){

            protected void serialize(MappingSerializer serializer) {
                ArrayList<1> maps = new ArrayList<1>();
                maps.add(new MappingRepresentation(this, "map"){

                    protected void serialize(MappingSerializer serializer) {
                        serializer.putString("foo", "bar");
                    }
                });
                serializer.putList("foo", (ListRepresentation)new ServerListRepresentation(RepresentationType.MAP, maps));
            }
        }, (RepresentationFormat)this.json, (URI)new URI("http://localhost/"));
        Assertions.assertEquals((Object)"bar", ((Map)((List)JsonHelper.jsonToMap((String)entity).get("foo")).get(0)).get("foo"));
    }
}

