/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.metrics;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.neo4j.server.queryapi.metrics.QueryAPIMetricsMonitor;

public class QueryAPIMetricsFilter
implements Filter {
    private final QueryAPIMetricsMonitor monitor;
    private final Pattern rootPattern;
    private final Pattern continuePattern;
    private final Pattern commitPattern;

    public QueryAPIMetricsFilter(QueryAPIMetricsMonitor monitor) {
        this.monitor = monitor;
        this.rootPattern = Pattern.compile(".*/query/v2.*");
        this.continuePattern = Pattern.compile(".*/query/v2/tx/.{4}");
        this.commitPattern = Pattern.compile(".*/query/v2/tx/.{4}/commit");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long execStartTime = System.currentTimeMillis();
        chain.doFilter(request, response);
        long totalExecutionTime = System.currentTimeMillis() - execStartTime;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletRequest.getRequestURI().matches(this.rootPattern.pattern())) {
            this.monitor.totalRequests();
            this.monitor.requestTimeTaken(totalExecutionTime);
            this.meterEndpoint(httpServletRequest.getRequestURI(), httpServletRequest.getMethod());
            this.meterRequest(httpServletRequest);
            this.meterResponse(httpServletResponse);
        }
    }

    private void meterRequest(HttpServletRequest httpServletRequest) {
        String contentType = httpServletRequest.getContentType();
        this.monitor.requestContentType(contentType);
        this.monitor.httpVersion(HttpVersion.fromString((String)httpServletRequest.getProtocol()));
    }

    private void meterEndpoint(String uri, String httpVerb) {
        if (uri.endsWith("/query/v2")) {
            this.monitor.autoCommitRequest();
        } else if (uri.endsWith("/query/v2/tx")) {
            this.monitor.beginRequest();
        } else if (uri.matches(this.continuePattern.pattern())) {
            if (httpVerb.equals("POST")) {
                this.monitor.continueRequest();
            } else {
                this.monitor.rollbackRequest();
            }
        } else if (uri.matches(this.commitPattern.pattern())) {
            this.monitor.commitRequest();
        }
    }

    private void meterResponse(HttpServletResponse response) {
        if (response == null) {
            return;
        }
        this.monitor.responseStatusCode(response.getStatus());
        String contentType = response.getContentType();
        if (contentType == null) {
            return;
        }
        this.monitor.responseContentType(contentType);
    }
}

