/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class AuthorizationHeaders {
    private AuthorizationHeaders() {
    }

    public static ParsedHeader decode(String authorizationHeader) {
        Scheme authScheme;
        String[] parts = authorizationHeader.trim().split(" ");
        String tokenSegment = parts[parts.length - 1];
        try {
            authScheme = Scheme.valueOf(parts[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        switch (authScheme.ordinal()) {
            case 0: {
                if (tokenSegment.isBlank()) {
                    return null;
                }
                String decoded = AuthorizationHeaders.decodeBase64(tokenSegment);
                if (decoded.isEmpty()) {
                    return null;
                }
                String[] userAndPassword = decoded.split(":", 2);
                if (userAndPassword.length != 2) {
                    return null;
                }
                return new ParsedHeader(Scheme.BASIC, userAndPassword);
            }
            case 1: {
                if (parts.length != 2) {
                    return null;
                }
                return new ParsedHeader(Scheme.BEARER, new String[]{parts[1]});
            }
        }
        return null;
    }

    private static String decodeBase64(String base64) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64);
            return new String(decodedBytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }

    public static enum Scheme {
        BASIC,
        BEARER;

    }

    public record ParsedHeader(Scheme scheme, String[] values) {
    }
}

