/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.driver;

import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalIoHandler;
import io.netty.util.concurrent.Future;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.DriverFactory;
import org.neo4j.driver.internal.security.StaticAuthTokenManager;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.queryapi.driver.DriverToInternalLogProvider;

public final class LocalChannelDriverFactory
extends DriverFactory
implements AutoCloseable {
    public static final URI IGNORED_HTTP_DRIVER_URI = URI.create("bolt://http-driver.com:0");
    private final LocalAddress localAddress;
    private final InternalLogProvider internalLogProvider;
    private final Config config;
    private final MultiThreadIoEventLoopGroup localGroup;

    public LocalChannelDriverFactory(LocalAddress localAddress, InternalLogProvider internalLogProvider, Config config) {
        this.localAddress = localAddress;
        this.internalLogProvider = internalLogProvider;
        this.config = config;
        this.localGroup = new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory());
    }

    protected LocalAddress localAddress() {
        return this.localAddress;
    }

    protected BoltConnectionProvider createBoltConnectionProvider(ScheduledExecutorService eventLoopGroup, Clock clock, LoggingProvider loggingProvider, int eventLoopThreads) {
        return new BoltConnectionProviderWithRoutingContext(super.createBoltConnectionProvider(eventLoopGroup, clock, loggingProvider, eventLoopThreads));
    }

    public Driver createLocalDriver() {
        return super.newInstance(IGNORED_HTTP_DRIVER_URI, (AuthTokenManager)new StaticAuthTokenManager(AuthTokens.none()), null, org.neo4j.driver.Config.builder().withLogging((Logging)new DriverToInternalLogProvider(this.internalLogProvider)).withUserAgent("neo4j-query-api/v2").build(), null, (ScheduledExecutorService)this.localGroup, null);
    }

    @Override
    public void close() throws Exception {
        Future workerTerminationFuture = this.localGroup.shutdownGracefully((long)((Integer)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_quiet_period)).intValue(), ((Duration)this.config.get(GraphDatabaseInternalSettings.netty_server_shutdown_timeout)).toSeconds(), TimeUnit.SECONDS);
        boolean workerTerminationCompleted = workerTerminationFuture.awaitUninterruptibly(((Duration)this.config.get(BoltConnectorInternalSettings.thread_pool_shutdown_wait_time)).toSeconds(), TimeUnit.SECONDS);
        if (!workerTerminationCompleted) {
            InternalLog log = this.internalLogProvider.getLog(LocalChannelDriverFactory.class);
            log.warn("Termination of local driver factory worker event loop group has exceeded maximum permitted duration - Remaining jobs will be forcefully terminated");
        } else if (!workerTerminationFuture.isSuccess()) {
            InternalLog log = this.internalLogProvider.getLog(LocalChannelDriverFactory.class);
            log.warn("Termination of local driver factory worker event loop group has failed", workerTerminationFuture.cause());
        }
    }

    private record BoltConnectionProviderWithRoutingContext(BoltConnectionProvider delegate) implements BoltConnectionProvider
    {
        public CompletionStage<BoltConnection> connect(URI uri, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
            try {
                uri = new URI("neo4j", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                return CompletableFuture.failedStage(e);
            }
            return this.delegate.connect(uri, routingContextAddress, boltAgent, userAgent, connectTimeoutMillis, securityPlan, authToken, minVersion, notificationConfig);
        }

        public CompletionStage<Void> close() {
            return this.delegate.close();
        }
    }
}

