/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.driver;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.server.queryapi.driver.QueryApiBoltConnection;

record QueryApiBoltConnectionProvider(BoltConnectionProvider delegate) implements BoltConnectionProvider
{
    public CompletionStage<BoltConnection> connect(URI uri, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, SecurityPlan securityPlan, AuthToken authToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        try {
            uri = new URI("neo4j", uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            return CompletableFuture.failedStage(e);
        }
        return this.delegate.connect(uri, routingContextAddress, boltAgent, userAgent, connectTimeoutMillis, securityPlan, authToken, minVersion, notificationConfig).thenApply(conn -> {
            conn.setReadTimeout(Duration.ofDays(Integer.MAX_VALUE));
            return conn;
        }).thenApply(QueryApiBoltConnection::new);
    }

    public CompletionStage<Void> close() {
        return this.delegate.close();
    }
}

