/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.queryapi.driver;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.observation.ImmutableObservation;
import org.neo4j.server.queryapi.driver.QueryApiBoltConnection;

@ExtendWith(value={MockitoExtension.class})
class QueryApiBoltConnectionTest {
    @Mock
    private BoltConnection delegate;
    @Mock
    private ImmutableObservation observation;
    @InjectMocks
    private QueryApiBoltConnection boltConnection;

    QueryApiBoltConnectionTest() {
    }

    @Test
    void setReadTimeout() throws ExecutionException, InterruptedException {
        CompletionStage result = this.boltConnection.setReadTimeout(Duration.ofDays(3L));
        Assertions.assertEquals(null, result.toCompletableFuture().get());
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).setReadTimeout((Duration)Mockito.any());
    }

    @Test
    void defaultReadTimeout() {
        Optional result = this.boltConnection.defaultReadTimeout();
        Assertions.assertTrue((boolean)result.isEmpty());
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.never())).defaultReadTimeout();
    }

    @Test
    void writeAndFlush() {
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        List messages = List.of();
        CompletionStage<Object> completionStage = CompletableFuture.completedStage(null);
        ((BoltConnection)Mockito.doReturn(completionStage).when((Object)this.delegate)).writeAndFlush(handler, messages, this.observation);
        CompletionStage result = this.boltConnection.writeAndFlush(handler, messages, this.observation);
        Assertions.assertSame(completionStage, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).writeAndFlush(handler, messages, this.observation);
    }

    @Test
    void write() {
        List messages = List.of();
        CompletionStage<Object> completionStage = CompletableFuture.completedStage(null);
        ((BoltConnection)Mockito.doReturn(completionStage).when((Object)this.delegate)).write(messages);
        CompletionStage result = this.boltConnection.write(messages);
        Assertions.assertSame(completionStage, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).write(messages);
    }

    @Test
    void forceClose() {
        String s = "Some reason";
        CompletionStage<Object> completionStage = CompletableFuture.completedStage(null);
        ((BoltConnection)Mockito.doReturn(completionStage).when((Object)this.delegate)).forceClose(s);
        CompletionStage result = this.boltConnection.forceClose(s);
        Assertions.assertSame(completionStage, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).forceClose(s);
    }

    @Test
    void close() {
        CompletionStage<Object> completionStage = CompletableFuture.completedStage(null);
        ((BoltConnection)Mockito.doReturn(completionStage).when((Object)this.delegate)).close();
        CompletionStage result = this.boltConnection.close();
        Assertions.assertSame(completionStage, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).close();
    }

    @Test
    void state() {
        BoltConnectionState expected = BoltConnectionState.OPEN;
        ((BoltConnection)Mockito.doReturn((Object)expected).when((Object)this.delegate)).state();
        BoltConnectionState result = this.boltConnection.state();
        Assertions.assertSame((Object)expected, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).state();
    }

    @Test
    void authInfo() {
        AuthInfo authInfo = (AuthInfo)Mockito.mock(AuthInfo.class);
        CompletionStage<AuthInfo> expected = CompletableFuture.completedStage(authInfo);
        ((BoltConnection)Mockito.doReturn(expected).when((Object)this.delegate)).authInfo();
        CompletionStage result = this.boltConnection.authInfo();
        Assertions.assertSame(expected, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).authInfo();
    }

    @Test
    void serverAgent() {
        String expected = "Agent";
        ((BoltConnection)Mockito.doReturn((Object)expected).when((Object)this.delegate)).serverAgent();
        String result = this.boltConnection.serverAgent();
        Assertions.assertSame((Object)expected, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).serverAgent();
    }

    @Test
    void serverAddress() {
        BoltServerAddress expected = (BoltServerAddress)Mockito.mock(BoltServerAddress.class);
        ((BoltConnection)Mockito.doReturn((Object)expected).when((Object)this.delegate)).serverAddress();
        BoltServerAddress result = this.boltConnection.serverAddress();
        Assertions.assertSame((Object)expected, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).serverAddress();
    }

    @Test
    void protocolVersion() {
        BoltProtocolVersion expected = (BoltProtocolVersion)Mockito.mock(BoltProtocolVersion.class);
        ((BoltConnection)Mockito.doReturn((Object)expected).when((Object)this.delegate)).protocolVersion();
        BoltProtocolVersion result = this.boltConnection.protocolVersion();
        Assertions.assertSame((Object)expected, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).protocolVersion();
    }

    @Test
    void telemetrySupported() {
        boolean expected = false;
        ((BoltConnection)Mockito.doReturn((Object)expected).when((Object)this.delegate)).telemetrySupported();
        boolean result = this.boltConnection.telemetrySupported();
        Assertions.assertSame((Object)expected, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).telemetrySupported();
    }

    @Test
    void serverSideRoutingEnabled() {
        boolean expected = true;
        ((BoltConnection)Mockito.doReturn((Object)expected).when((Object)this.delegate)).serverSideRoutingEnabled();
        boolean result = this.boltConnection.serverSideRoutingEnabled();
        Assertions.assertSame((Object)expected, (Object)result);
        ((BoltConnection)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.only())).serverSideRoutingEnabled();
    }

    @Test
    void delegate() {
        Assertions.assertSame((Object)this.delegate, (Object)this.boltConnection.delegate());
    }
}

