/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class BoltIT
extends ExclusiveServerTestBase {
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldLaunchBolt() throws Throwable {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.bolt_enabled.name(), "true").withProperty(ServerSettings.bolt_tls_enabled.name(), "true").usingDatabaseDir(this.tmpDir.getRoot().getAbsolutePath()).build();
        this.server.start();
        this.assertEventuallyServerResponds("localhost", 7687);
    }

    @Test
    public void shouldBeAbleToSpecifyHostAndPort() throws Throwable {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.bolt_enabled.name(), "true").withProperty(ServerSettings.bolt_tls_enabled.name(), "true").withProperty(ServerSettings.bolt_socket_address.name(), "localhost:8776").usingDatabaseDir(this.tmpDir.getRoot().getAbsolutePath()).build();
        this.server.start();
        this.assertEventuallyServerResponds("localhost", 8776);
    }

    private void assertEventuallyServerResponds(String host, int port) throws Exception {
        SecureSocketConnection conn = new SecureSocketConnection();
        conn.connect(new HostnamePort(host, port));
        conn.send(new byte[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        MatcherAssert.assertThat((Object)conn.recv(4), (Matcher)Matchers.equalTo((Object)new byte[]{0, 0, 0, 1}));
    }
}

