/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.bolt.BoltKernelExtension;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Settings;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.kernel.configuration.Obsoleted;
import org.neo4j.server.configuration.HttpLogSetting;
import org.neo4j.server.configuration.ServerConfigurationMigrator;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

@Description(value="Settings used by the server configuration")
public interface ServerSettings {
    @Migrator
    public static final ConfigurationMigrator migrator = new ServerConfigurationMigrator();
    @Description(value="Maximum request header size")
    public static final Setting<Integer> maximum_request_header_size = Settings.setting((String)"org.neo4j.server.webserver.max.request.header", (Function)Settings.INTEGER, (String)"20480");
    @Description(value="Maximum response header size")
    public static final Setting<Integer> maximum_response_header_size = Settings.setting((String)"org.neo4j.server.webserver.max.response.header", (Function)Settings.INTEGER, (String)"20480");
    @Description(value="Comma-seperated list of custom security rules for Neo4j to use.")
    public static final Setting<List<String>> security_rules = Settings.setting((String)"org.neo4j.server.rest.security_rules", (Function)Settings.STRING_LIST, (String)"");
    @Description(value="Http port for the Neo4j REST API.")
    public static final Setting<Integer> webserver_port = Settings.setting((String)"org.neo4j.server.webserver.port", (Function)Settings.INTEGER, (String)"7474", (Function2[])new Function2[]{Settings.port});
    @Description(value="Hostname for the Neo4j REST API")
    public static final Setting<String> webserver_address = Settings.setting((String)"org.neo4j.server.webserver.address", (Function)Settings.STRING, (String)"localhost", (Function2[])new Function2[]{Settings.illegalValueMessage((String)"Must be a valid hostname", (Function2)Settings.matches((String)".+"))});
    @Description(value="Number of Neo4j worker threads.")
    public static final Setting<Integer> webserver_max_threads = Settings.setting((String)"org.neo4j.server.webserver.maxthreads", (Function)Settings.INTEGER, (String)("" + Math.min(Runtime.getRuntime().availableProcessors(), 500)), (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(1))});
    @Description(value="If execution time limiting is enabled in the database, this configures the maximum request execution time.")
    public static final Setting<Long> webserver_limit_execution_time = Settings.setting((String)"org.neo4j.server.webserver.limit.executiontime", (Function)Settings.DURATION, (String)Settings.NO_DEFAULT);
    @Deprecated
    @Obsoleted(value="RRDB was removed in 3.0")
    @Description(value="Path to the statistics database file. RRDB has been deprecate, please use the Metrics plugin instead.")
    public static final Setting<File> rrdb_location = Settings.setting((String)"org.neo4j.server.webadmin.rrdb.location", (Function)Settings.PATH, (String)Settings.NO_DEFAULT);
    @Description(value="Console engines for the legacy webadmin administration")
    public static final Setting<List<String>> management_console_engines = Settings.setting((String)"org.neo4j.server.manage.console_engines", (Function)Settings.STRING_LIST, (String)"SHELL");
    @Description(value="Comma-separated list of <classname>=<mount point> for unmanaged extensions.")
    public static final Setting<List<ThirdPartyJaxRsPackage>> third_party_packages = Settings.setting((String)"org.neo4j.server.thirdparty_jaxrs_classes", (Function)new Function<String, List<ThirdPartyJaxRsPackage>>(){

        public List<ThirdPartyJaxRsPackage> apply(String value) {
            String[] list = value.split(",");
            ArrayList<ThirdPartyJaxRsPackage> result = new ArrayList<ThirdPartyJaxRsPackage>();
            for (String item : list) {
                if ((item = item.trim()).equals("")) continue;
                result.add(this.createThirdPartyJaxRsPackage(item));
            }
            return result;
        }

        public String toString() {
            return "a comma-seperated list of <classname>=<mount point> strings";
        }

        private ThirdPartyJaxRsPackage createThirdPartyJaxRsPackage(String packageAndMoutpoint) {
            String[] parts = packageAndMoutpoint.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("config for " + third_party_packages.name() + " is wrong: " + packageAndMoutpoint);
            }
            String pkg = parts[0];
            String mountPoint = parts[1];
            return new ThirdPartyJaxRsPackage(pkg, mountPoint);
        }
    }, (String)"");
    @Description(value="Enable HTTPS for the REST API.")
    public static final Setting<Boolean> webserver_https_enabled = Settings.setting((String)"org.neo4j.server.webserver.https.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="HTTPS port for the REST API.")
    public static final Setting<Integer> webserver_https_port = Settings.setting((String)"org.neo4j.server.webserver.https.port", (Function)Settings.INTEGER, (String)"7473", (Function2[])new Function2[]{Settings.port});
    @Description(value="Path to the X.509 public certificate to be used by Neo4j for TLS connections")
    public static final Setting<File> tls_certificate_file = Settings.setting((String)"dbms.security.tls_certificate_file", (Function)Settings.PATH, (String)"neo4j-home/ssl/snakeoil.cert");
    @Description(value="Path to the X.509 private key to be used by Neo4j for TLS connections")
    public static final Setting<File> tls_key_file = Settings.setting((String)"dbms.security.tls_key_file", (Function)Settings.PATH, (String)"neo4j-home/ssl/snakeoil.key");
    @Deprecated
    @Description(value="Path to the SSL certificate used for HTTPS connections. This is deprecated, please use 'dbms.security.tls_certificate_file' instead.")
    public static final Setting<File> webserver_https_cert_path = Settings.setting((String)"org.neo4j.server.webserver.https.cert.location", (Function)Settings.PATH, (String)"neo4j-home/ssl/snakeoil.cert");
    @Deprecated
    @Description(value="Path to the SSL key used for HTTPS connections. This is deprecated, please use 'dbms.security.tls_key_file'")
    public static final Setting<File> webserver_https_key_path = Settings.setting((String)"org.neo4j.server.webserver.https.key.location", (Function)Settings.PATH, (String)"neo4j-home/ssl/snakeoil.key");
    @Description(value="Enable HTTP request logging.")
    public static final Setting<Boolean> http_logging_enabled = Settings.setting((String)"org.neo4j.server.http.log.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Enable HTTP content logging.")
    public static final Setting<Boolean> http_content_logging_enabled = Settings.setting((String)"org.neo4j.server.http.unsafe.content_log.enabled", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Path to a logback configuration file for HTTP request logging.")
    public static final Setting<File> http_log_config_file = Settings.setting((String)"org.neo4j.server.http.log.config", (Function)new HttpLogSetting(), (String)Settings.NO_DEFAULT);
    @Description(value="Timeout for idle transactions.")
    public static final Setting<Long> transaction_timeout = Settings.setting((String)"org.neo4j.server.transaction.timeout", (Function)Settings.DURATION, (String)"60s");
    @Description(value="Enable auth requirement to access Neo4j.")
    public static final Setting<Boolean> auth_enabled = Settings.setting((String)"dbms.security.auth_enabled", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Enable the Bolt protocol")
    public static final Setting<Boolean> bolt_enabled = BoltKernelExtension.Settings.enabled;
    @Description(value="Enable TLS for Bolt")
    public static final Setting<Boolean> bolt_tls_enabled = BoltKernelExtension.Settings.tls_enabled;
    @Description(value="Host and port for Bolt TCP transport")
    public static final Setting<HostnamePort> bolt_socket_address = BoltKernelExtension.Settings.socket_address;
    @Description(value="Host and port for the Bolt Websocket transport")
    public static final Setting<HostnamePort> bolt_ws_address = BoltKernelExtension.Settings.websocket_address;
}

