/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.server.ExclusiveServerTestBase;

public abstract class BaseBootstrapperTest
extends ExclusiveServerTestBase {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private Bootstrapper bootstrapper;

    protected abstract Bootstrapper newBootstrapper() throws IOException;

    @Test
    public void shouldStartStopNeoServerWithoutAnyConfigFiles() throws IOException {
        this.bootstrapper = this.newBootstrapper();
        String[] propertiesArray = this.getDefaultPropertiesArray();
        int resultCode = CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])propertiesArray);
        Assert.assertEquals((long)0L, (long)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
    }

    @Test
    public void canSpecifyConfigFile() throws Throwable {
        this.bootstrapper = this.newBootstrapper();
        File configFile = this.tempDir.newFile("neo4j.config");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "ourcustomvalue"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        MapUtil.store((Map)properties, (File)configFile);
        CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])((String[])ArrayUtil.array((Object[])new String[]{"-C", configFile.getAbsolutePath()})));
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"ourcustomvalue"));
    }

    @Test
    public void canOverrideConfigValues() throws Throwable {
        this.bootstrapper = this.newBootstrapper();
        File configFile = this.tempDir.newFile("neo4j.config");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "thisshouldnotshowup"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        MapUtil.store((Map)properties, (File)configFile);
        CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])((String[])ArrayUtil.array((Object[])new String[]{"-C", configFile.getAbsolutePath(), "-c", this.configOption(GraphDatabaseSettings.forced_kernel_id.name(), "mycustomvalue")})));
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"mycustomvalue"));
    }

    @After
    public void cleanup() {
        if (this.bootstrapper != null) {
            this.bootstrapper.stop();
        }
    }

    private String[] getDefaultPropertiesArray() throws IOException {
        Map<String, String> properties = ServerTestUtils.getDefaultRelativeProperties();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            values.add("-c");
            values.add(this.configOption(entry.getKey(), entry.getValue()));
        }
        return values.toArray(new String[values.size()]);
    }

    private String configOption(String key, String value) {
        return key + "=" + value;
    }
}

