/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.UnitOfWork;

public class ServerHelper {
    public static void cleanTheDatabase(NeoServer server) {
        if (server == null) {
            return;
        }
        ServerHelper.rollbackAllOpenTransactions(server);
        ServerHelper.cleanTheDatabase(server.getDatabase().getGraph());
        ServerHelper.removeLogs(server);
    }

    public static void cleanTheDatabase(GraphDatabaseAPI db) {
        new Transactor((GraphDatabaseService)db, new DeleteAllData(db), 10).execute();
        new Transactor((GraphDatabaseService)db, new DeleteAllSchema(db), 10).execute();
    }

    private static void removeLogs(NeoServer server) {
        File logDir = new File(server.getDatabase().getLocation() + File.separator + ".." + File.separator + "log");
        try {
            FileUtils.deleteDirectory((File)logDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NeoServer createNonPersistentServer() throws IOException {
        return ServerHelper.createServer(CommunityServerBuilder.server(), false, null);
    }

    public static NeoServer createNonPersistentReadOnlyServer() throws IOException {
        CommunityServerBuilder builder = CommunityServerBuilder.server();
        builder.withProperty(GraphDatabaseSettings.read_only.name(), "true");
        return ServerHelper.createServer(builder, false, null);
    }

    public static NeoServer createNonPersistentServer(LogProvider logProvider) throws IOException {
        return ServerHelper.createServer(CommunityServerBuilder.server(logProvider), false, null);
    }

    public static NeoServer createNonPersistentServer(CommunityServerBuilder builder) throws IOException {
        return ServerHelper.createServer(builder, false, null);
    }

    public static NeoServer createPersistentServer(File path) throws IOException {
        return ServerHelper.createServer(CommunityServerBuilder.server(), true, path);
    }

    public static NeoServer createPersistentServer(File path, LogProvider logProvider) throws IOException {
        return ServerHelper.createServer(CommunityServerBuilder.server(logProvider), true, path);
    }

    private static NeoServer createServer(CommunityServerBuilder builder, boolean persistent, File path) throws IOException {
        ServerHelper.configureHostname(builder);
        if (persistent) {
            builder = builder.persistent();
        }
        CommunityNeoServer server = builder.usingDatabaseDir(path != null ? path.getAbsolutePath() : null).build();
        ServerHelper.checkServerCanStart(server.baseUri().getHost(), server.baseUri().getPort());
        server.start();
        return server;
    }

    private static void checkServerCanStart(String host, int port) throws IOException {
        try (ServerSocket serverSocket = null;){
            serverSocket = new ServerSocket(port, 1, InetAddress.getByName(host));
        }
    }

    private static void configureHostname(CommunityServerBuilder builder) {
        String hostName = System.getProperty("neo-server.test.hostname");
        if (StringUtils.isNotEmpty((String)hostName)) {
            builder.onHost(hostName);
        }
    }

    private static void rollbackAllOpenTransactions(NeoServer server) {
        server.getTransactionRegistry().rollbackAllSuspendedTransactions();
    }

    private static class DeleteAllSchema
    implements UnitOfWork {
        private final GraphDatabaseAPI db;

        public DeleteAllSchema(GraphDatabaseAPI db) {
            this.db = db;
        }

        @Override
        public void doWork() {
            this.deleteAllIndexRules();
            this.deleteAllConstraints();
        }

        private void deleteAllIndexRules() {
            for (IndexDefinition index : this.db.schema().getIndexes()) {
                if (index.isConstraintIndex()) continue;
                index.drop();
            }
        }

        private void deleteAllConstraints() {
            for (ConstraintDefinition constraint : this.db.schema().getConstraints()) {
                constraint.drop();
            }
        }
    }

    private static class DeleteAllData
    implements UnitOfWork {
        private final GraphDatabaseAPI db;

        public DeleteAllData(GraphDatabaseAPI db) {
            this.db = db;
        }

        @Override
        public void doWork() {
            this.deleteAllNodesAndRelationships();
            this.deleteAllIndexes();
        }

        private void deleteAllNodesAndRelationships() {
            ResourceIterable allNodes = this.db.getAllNodes();
            for (Node n : allNodes) {
                Iterable relationships = n.getRelationships();
                for (Relationship rel : relationships) {
                    rel.delete();
                }
                n.delete();
            }
        }

        private void deleteAllIndexes() {
            IndexManager indexManager = this.db.index();
            for (String indexName : indexManager.nodeIndexNames()) {
                try {
                    this.db.index().forNodes(indexName).delete();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            for (String indexName : indexManager.relationshipIndexNames()) {
                try {
                    this.db.index().forRelationships(indexName).delete();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            for (String k : indexManager.getNodeAutoIndexer().getAutoIndexedProperties()) {
                indexManager.getNodeAutoIndexer().stopAutoIndexingProperty(k);
            }
            indexManager.getNodeAutoIndexer().setEnabled(false);
            for (String k : indexManager.getRelationshipAutoIndexer().getAutoIndexedProperties()) {
                indexManager.getRelationshipAutoIndexer().stopAutoIndexingProperty(k);
            }
            indexManager.getRelationshipAutoIndexer().setEnabled(false);
        }
    }
}

