/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserSerialization;

public class UserSerializationTest {
    @Test
    public void shouldSerializeAndDeserialize() throws Exception {
        UserSerialization serialization = new UserSerialization();
        List<User> users = Arrays.asList(new User("Steve", Credential.forPassword((String)"1234321"), false), new User("Bob", Credential.forPassword((String)"0987654"), false));
        byte[] serialized = serialization.serialize(users);
        MatcherAssert.assertThat((Object)serialization.deserializeUsers(serialized), (Matcher)Matchers.equalTo(users));
    }

    @Test
    public void shouldReadV1SerializationFormat() throws Exception {
        UserSerialization serialization = new UserSerialization();
        byte[] salt1 = new byte[]{-91, 67};
        byte[] hash1 = new byte[]{-2, 0, 86, -61, 126};
        byte[] salt2 = new byte[]{52, -92};
        byte[] hash2 = new byte[]{14, 31, -1, -62, 62};
        List deserialized = serialization.deserializeUsers(UTF8.encode((String)"Steve:SHA-256,FE0056C37E,A543:\nBob:SHA-256,0E1FFFC23E,34A4:password_change_required\n"));
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.equalTo(Arrays.asList(new User("Steve", new Credential(salt1, hash1), false), new User("Bob", new Credential(salt2, hash2), true))));
    }
}

