/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.SuppressOutput;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class TestJetty9WebServer
extends ExclusiveServerTestBase {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private Jetty9WebServer webServer;
    private CommunityNeoServer server;

    @Test
    public void shouldBeAbleToUsePortZero() throws Exception {
        this.webServer = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), new Config());
        this.webServer.setPort(0);
        this.webServer.start();
    }

    @Test
    public void shouldBeAbleToRestart() throws Throwable {
        this.webServer = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), new Config());
        this.webServer.setAddress("127.0.0.1");
        this.webServer.setPort(7878);
        this.webServer.start();
        this.webServer.stop();
        this.webServer.start();
    }

    @Test
    public void shouldBeAbleToSetExecutionLimit() throws Throwable {
        Map<String, String> properties = ServerTestUtils.getDefaultRelativeProperties();
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase(new File("path"), properties, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies());
        ServerConfigurator config = this.buildConfig(properties, db);
        WrappingNeoServerBootstrapper testBootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)config);
        testBootstrapper.start();
        testBootstrapper.stop();
    }

    private ServerConfigurator buildConfig(Map<String, String> properties, ImpermanentGraphDatabase db) {
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)db);
        Configuration configuration = config.configuration();
        Set<Map.Entry<String, String>> testSettings = properties.entrySet();
        for (Map.Entry<String, String> testSetting : testSettings) {
            configuration.setProperty(testSetting.getKey(), (Object)testSetting.getValue());
        }
        configuration.setProperty(Configurator.WEBSERVER_LIMIT_EXECUTION_TIME_PROPERTY_KEY, (Object)"1000s");
        return config;
    }

    @Test
    public void shouldStopCleanlyEvenWhenItHasntBeenStarted() {
        new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), null).stop();
    }

    @Test
    public void shouldDisallowDirectoryListings() throws Exception {
        this.server = CommunityServerBuilder.server().build();
        this.server.start();
        HTTP.Response okResource = HTTP.GET(this.server.baseUri().resolve("/webadmin/index.html").toString());
        HTTP.Response illegalResource = HTTP.GET(this.server.baseUri().resolve("/webadmin/css/").toString());
        Assert.assertEquals((long)200L, (long)okResource.status());
        Assert.assertEquals((long)403L, (long)illegalResource.status());
    }

    @After
    public void cleanup() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }
}

