/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Collection;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.rest.repr.EntityRepresentation;
import org.neo4j.server.rest.repr.ExtensibleRepresentation;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MapRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.MappingWriter;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.PropertiesRepresentation;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public final class NodeRepresentation
extends ObjectRepresentation
implements ExtensibleRepresentation,
EntityRepresentation {
    private final Node node;

    public NodeRepresentation(Node node) {
        super(RepresentationType.NODE);
        this.node = node;
    }

    public String getIdentity() {
        return Long.toString(this.node.getId());
    }

    @Override
    @ObjectRepresentation.Mapping(value="self")
    public ValueRepresentation selfUri() {
        return ValueRepresentation.uri((String)this.path(""));
    }

    public long getId() {
        return this.node.getId();
    }

    private String path(String path) {
        return "node/" + this.node.getId() + path;
    }

    static String path(Node node) {
        return "node/" + node.getId();
    }

    @ObjectRepresentation.Mapping(value="create_relationship")
    public ValueRepresentation relationshipCreationUri() {
        return ValueRepresentation.uri((String)this.path("/relationships"));
    }

    @ObjectRepresentation.Mapping(value="all_relationships")
    public ValueRepresentation allRelationshipsUri() {
        return ValueRepresentation.uri((String)this.path("/relationships/all"));
    }

    @ObjectRepresentation.Mapping(value="incoming_relationships")
    public ValueRepresentation incomingRelationshipsUri() {
        return ValueRepresentation.uri((String)this.path("/relationships/in"));
    }

    @ObjectRepresentation.Mapping(value="outgoing_relationships")
    public ValueRepresentation outgoingRelationshipsUri() {
        return ValueRepresentation.uri((String)this.path("/relationships/out"));
    }

    @ObjectRepresentation.Mapping(value="all_typed_relationships")
    public ValueRepresentation allTypedRelationshipsUriTemplate() {
        return ValueRepresentation.template((String)this.path("/relationships/all/{-list|&|types}"));
    }

    @ObjectRepresentation.Mapping(value="incoming_typed_relationships")
    public ValueRepresentation incomingTypedRelationshipsUriTemplate() {
        return ValueRepresentation.template((String)this.path("/relationships/in/{-list|&|types}"));
    }

    @ObjectRepresentation.Mapping(value="outgoing_typed_relationships")
    public ValueRepresentation outgoingTypedRelationshipsUriTemplate() {
        return ValueRepresentation.template((String)this.path("/relationships/out/{-list|&|types}"));
    }

    @ObjectRepresentation.Mapping(value="labels")
    public ValueRepresentation labelsUriTemplate() {
        return ValueRepresentation.template((String)this.path("/labels"));
    }

    @ObjectRepresentation.Mapping(value="properties")
    public ValueRepresentation propertiesUri() {
        return ValueRepresentation.uri((String)this.path("/properties"));
    }

    @ObjectRepresentation.Mapping(value="property")
    public ValueRepresentation propertyUriTemplate() {
        return ValueRepresentation.template((String)this.path("/properties/{key}"));
    }

    @ObjectRepresentation.Mapping(value="traverse")
    public ValueRepresentation traverseUriTemplate() {
        return ValueRepresentation.template((String)this.path("/traverse/{returnType}"));
    }

    @ObjectRepresentation.Mapping(value="paged_traverse")
    public ValueRepresentation pagedTraverseUriTemplate() {
        return ValueRepresentation.template((String)this.path("/paged/traverse/{returnType}{?pageSize,leaseTime}"));
    }

    @ObjectRepresentation.Mapping(value="metadata")
    public MapRepresentation metadata() {
        Collection labels = IteratorUtil.asCollection((Iterable)new IterableWrapper<String, Label>(this.node.getLabels()){

            protected String underlyingObjectToObject(Label label) {
                return label.name();
            }
        });
        return new MapRepresentation(MapUtil.map((Object[])new Object[]{"id", this.node.getId(), "labels", labels}));
    }

    @Override
    void extraData(MappingSerializer serializer) {
        MappingWriter writer = serializer.writer;
        MappingWriter properties = writer.newMapping(RepresentationType.PROPERTIES, "data");
        new PropertiesRepresentation((PropertyContainer)this.node).serialize(properties);
        if (writer.isInteractive()) {
            serializer.putList("relationship_types", ListRepresentation.relationshipTypes((Iterable)this.node.getGraphDatabase().getAllRelationshipTypes()));
        }
        properties.done();
    }

    public static ListRepresentation list(Iterable<Node> nodes) {
        return new ListRepresentation(RepresentationType.NODE, (Iterable)new IterableWrapper<Representation, Node>(nodes){

            protected Representation underlyingObjectToObject(Node node) {
                return new NodeRepresentation(node);
            }
        });
    }
}

