/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.server.ServerCommandLineArgs;

public class ServerCommandLineArgsTest {
    @Test
    public void shouldPickUpSpecifiedConfigFile() throws Exception {
        this.shouldPickUpSpecifiedConfigFile("config");
        this.shouldPickUpSpecifiedConfigFile("C");
    }

    public void shouldPickUpSpecifiedConfigFile(String key) {
        String customConfigFile = "MyConfigFile";
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"--" + key, customConfigFile});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)new File(customConfigFile), (Object)parsed.configFile());
    }

    @Test
    public void shouldPickUpOverriddenConfigurationParameters() throws Exception {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoption=myvalue"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Pair[]{Pair.of((Object)"myoption", (Object)"myvalue")}), (Object)IteratorUtil.asSet((Object[])parsed.configOverrides()));
    }

    @Test
    public void shouldPickUpOverriddenBooleanConfigurationParameters() throws Exception {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "myoptionenabled"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Pair[]{Pair.of((Object)"myoptionenabled", (Object)Boolean.TRUE.toString())}), (Object)IteratorUtil.asSet((Object[])parsed.configOverrides()));
    }

    @Test
    public void shouldPickUpMultipleOverriddenConfigurationParameters() throws Exception {
        String[] args = (String[])ArrayUtil.array((Object[])new String[]{"-c", "my_first_option=first", "-c", "myoptionenabled", "-c", "my_second_option=second"});
        ServerCommandLineArgs parsed = ServerCommandLineArgs.parse((String[])args);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Pair[]{Pair.of((Object)"my_first_option", (Object)"first"), Pair.of((Object)"myoptionenabled", (Object)Boolean.TRUE.toString()), Pair.of((Object)"my_second_option", (Object)"second")}), (Object)IteratorUtil.asSet((Object[])parsed.configOverrides()));
    }
}

