/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.StreamingFormat;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class GetOnRootDocIT
extends AbstractRestFunctionalTestBase {
    @TestData.Title(value="Get service root")
    @Documented(value="The service root is your starting point to discover the REST API. It contains the basic starting points for the database, and some version and extension information.")
    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void assert200OkFromGet() throws Exception {
        JaxRsResponse response;
        String body = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(200).get(GetOnRootDocIT.getDataUri()).entity();
        Map map = JsonHelper.jsonToMap((String)body);
        Assert.assertEquals((Object)(GetOnRootDocIT.getDataUri() + "node"), map.get("node"));
        Assert.assertNotNull(map.get("node_index"));
        Assert.assertNotNull(map.get("relationship_index"));
        Assert.assertNotNull(map.get("extensions_info"));
        Assert.assertNotNull(map.get("batch"));
        Assert.assertNotNull(map.get("cypher"));
        Assert.assertNotNull(map.get("indexes"));
        Assert.assertNotNull(map.get("constraints"));
        Assert.assertNotNull(map.get("node_labels"));
        Assert.assertEquals((Object)Version.getKernel().getReleaseVersion(), map.get("neo4j_version"));
        if (map.get("reference_node") != null) {
            response = RestRequest.req().get((String)map.get("reference_node"));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
        }
        Assert.assertTrue(((response = RestRequest.req().get((String)map.get("node_index"))).getStatus() == 200 || response.getStatus() == 204 ? 1 : 0) != 0);
        response.close();
        response = RestRequest.req().get((String)map.get("relationship_index"));
        Assert.assertTrue((response.getStatus() == 200 || response.getStatus() == 204 ? 1 : 0) != 0);
        response.close();
        response = RestRequest.req().get((String)map.get("extensions_info"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().post((String)map.get("batch"), "[]");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().post((String)map.get("cypher"), "{\"query\":\"CREATE (n) RETURN n\"}");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().get((String)map.get("indexes"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().get((String)map.get("constraints"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = RestRequest.req().get((String)map.get("node_labels"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Documented(value="All responses from the REST API can be transmitted as JSON streams, resulting in\nbetter performance and lower memory overhead on the server side. To use\nstreaming, supply the header `X-Stream: true` with each request.")
    @Test
    public void streaming() throws Exception {
        this.data.get();
        RESTDocsGenerator.ResponseEntity responseEntity = this.gen().docHeadingLevel(2).noGraph().withHeader("X-Stream", "true").expectedType(MediaType.APPLICATION_JSON_TYPE).expectedStatus(200).get(GetOnRootDocIT.getDataUri());
        JaxRsResponse response = responseEntity.response();
        String foundMediaType = response.getType().toString();
        String expectedMediaType = StreamingFormat.MEDIA_TYPE.toString();
        Assert.assertEquals((Object)expectedMediaType, (Object)foundMediaType);
        String body = responseEntity.entity();
        Map map = JsonHelper.jsonToMap((String)body);
        Assert.assertEquals((Object)(GetOnRootDocIT.getDataUri() + "node"), map.get("node"));
    }
}

