/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.neo4j.concurrent.RecentK;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.Database;
import org.neo4j.server.guard.GuardingRequestFilter;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.web.BatchOperationService;
import org.neo4j.server.rest.web.CollectUserAgentFilter;
import org.neo4j.server.rest.web.CypherService;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.server.rest.web.ExtensionService;
import org.neo4j.server.rest.web.ResourcesService;
import org.neo4j.server.rest.web.RestfulGraphDatabase;
import org.neo4j.server.rest.web.TransactionalService;
import org.neo4j.server.web.WebServer;
import org.neo4j.udc.UsageData;
import org.neo4j.udc.UsageDataKeys;

public class RESTApiModule
implements ServerModule {
    private final Config config;
    private final WebServer webServer;
    private final Database database;
    private DependencyResolver dependencyResolver;
    private final LogProvider logProvider;
    private final Log log;
    private PluginManager plugins;
    private GuardingRequestFilter requestTimeLimitFilter;

    public RESTApiModule(WebServer webServer, Database database, Config config, DependencyResolver dependencyResolver, LogProvider logProvider) {
        this.webServer = webServer;
        this.config = config;
        this.database = database;
        this.dependencyResolver = dependencyResolver;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void start() {
        try {
            URI restApiUri = this.restApiUri();
            this.webServer.addFilter(new CollectUserAgentFilter(this.clientNames()), "/*");
            this.webServer.addJAXRSClasses(this.getClassNames(), restApiUri.toString(), null);
            this.loadPlugins();
            this.setupRequestTimeLimit();
        }
        catch (URISyntaxException e) {
            this.log.warn("Unable to mount REST API", (Throwable)e);
        }
    }

    private RecentK<String> clientNames() {
        return (RecentK)((UsageData)this.dependencyResolver.resolveDependency(UsageData.class)).get(UsageDataKeys.clientNames);
    }

    private List<String> getClassNames() {
        return Arrays.asList(RestfulGraphDatabase.class.getName(), TransactionalService.class.getName(), CypherService.class.getName(), DatabaseMetadataService.class.getName(), ExtensionService.class.getName(), ResourcesService.class.getName(), BatchOperationService.class.getName());
    }

    @Override
    public void stop() {
        try {
            this.webServer.removeJAXRSClasses(this.getClassNames(), this.restApiUri().toString());
            this.tearDownRequestTimeLimit();
            this.unloadPlugins();
        }
        catch (URISyntaxException e) {
            this.log.warn("Unable to unmount REST API", (Throwable)e);
        }
    }

    private void tearDownRequestTimeLimit() {
        if (this.requestTimeLimitFilter != null) {
            this.webServer.removeFilter(this.requestTimeLimitFilter, "/*");
        }
    }

    private void setupRequestTimeLimit() {
        Long limit = (Long)this.config.get(ServerSettings.webserver_limit_execution_time);
        if (limit != null) {
            try {
                Guard guard = (Guard)this.database.getGraph().getDependencyResolver().resolveDependency(Guard.class);
                this.requestTimeLimitFilter = new GuardingRequestFilter(guard, limit);
                this.webServer.addFilter(this.requestTimeLimitFilter, "/*");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unable to use guard, you have to enable guard in neo4j.properties", e);
            }
        }
    }

    private URI restApiUri() throws URISyntaxException {
        return (URI)this.config.get(ServerSettings.rest_api_path);
    }

    private void loadPlugins() {
        this.plugins = new PluginManager(this.config, this.logProvider);
    }

    private void unloadPlugins() {
    }

    public PluginManager getPlugins() {
        return this.plugins;
    }
}

