/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;

public class ConfigFileBuilder {
    private final ArrayList<Tuple> nameValuePairs = new ArrayList();
    private final File directory;

    public static ConfigFileBuilder builder(File directory) {
        return new ConfigFileBuilder(directory);
    }

    private ConfigFileBuilder(File directory) {
        this.directory = directory;
    }

    public File build() throws IOException {
        File file = new File(this.directory, "config");
        Map config = MapUtil.stringMap((String[])new String[]{ServerSettings.legacy_db_location.name(), this.directory.getAbsolutePath(), ServerSettings.management_api_path.name(), "http://localhost:7474/db/manage/", ServerSettings.rest_api_path.name(), "http://localhost:7474/db/data/"});
        config.put(ServerSettings.webserver_port.name(), "7474");
        for (Tuple t : this.nameValuePairs) {
            config.put(t.name, t.value);
        }
        ServerTestUtils.writeConfigToFile(config, file);
        return file;
    }

    public ConfigFileBuilder withNameValue(String name, String value) {
        this.nameValuePairs.add(new Tuple(name, value));
        return this;
    }

    private static class Tuple {
        public String name;
        public String value;

        public Tuple(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

