/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.database.LifecycleManagingDatabase;

public class LifecycleManagingDatabaseTest {
    @Test
    public void mustIgnoreExceptionsFromPreLoadingCypherQuery() throws Throwable {
        final GraphDatabaseAPI mockDb = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        Config config = new Config();
        GraphDatabaseDependencies deps = GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance());
        LifecycleManagingDatabase.GraphFactory factory = new LifecycleManagingDatabase.GraphFactory(){

            public GraphDatabaseAPI newGraphDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return mockDb;
            }
        };
        LifecycleManagingDatabase db = new LifecycleManagingDatabase(config, factory, (GraphDatabaseFacadeFactory.Dependencies)deps){

            protected boolean isInTestMode() {
                return false;
            }
        };
        Mockito.when((Object)mockDb.execute("MATCH (a:` Arbitrary label name that really doesn't matter `) RETURN a LIMIT 0")).thenThrow(new Throwable[]{new TransactionFailureException("Boo")});
        db.init();
        db.start();
        Assert.assertTrue((String)"the database should be running", (boolean)db.isRunning());
        db.stop();
        db.shutdown();
    }
}

