/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.BaseServerConfigLoader;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.test.ImpermanentGraphDatabase;

public class CommunityServerBuilder {
    protected final LogProvider logProvider;
    private String portNo = "7474";
    private String maxThreads = null;
    protected String dbDir = null;
    private String webAdminUri = "/db/manage/";
    private String webAdminDataUri = "/db/data/";
    protected PreFlightTasks preflightTasks;
    private final HashMap<String, String> thirdPartyPackages = new HashMap();
    private final Properties arbitraryProperties = new Properties();
    public static LifecycleManagingDatabase.GraphFactory IN_MEMORY_DB = (config, dependencies) -> {
        File storeDir = (File)config.get(ServerSettings.legacy_db_location);
        Map params = config.getParams();
        params.put(GraphDatabaseFacadeFactory.Configuration.ephemeral.name(), "true");
        return new ImpermanentGraphDatabase(storeDir, params, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)dependencies));
    };
    protected Clock clock = null;
    private String[] autoIndexedNodeKeys = null;
    private String[] autoIndexedRelationshipKeys = null;
    private String host = null;
    private String[] securityRuleClassNames;
    public boolean persistent;
    private Boolean httpsEnabled = Boolean.FALSE;

    public static CommunityServerBuilder server(LogProvider logProvider) {
        return new CommunityServerBuilder(logProvider);
    }

    public static CommunityServerBuilder server() {
        return new CommunityServerBuilder((LogProvider)NullLogProvider.getInstance());
    }

    public CommunityNeoServer build() throws IOException {
        if (this.dbDir == null && this.persistent) {
            throw new IllegalStateException("Must specify path");
        }
        File configFile = this.buildBefore();
        Log log = this.logProvider.getLog(this.getClass());
        BaseServerConfigLoader configLoader = new BaseServerConfigLoader();
        Config config = configLoader.loadConfig(null, configFile, log, new Pair[0]);
        return this.build(configFile, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider(this.logProvider).monitors(new Monitors()));
    }

    protected CommunityNeoServer build(File configFile, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new TestCommunityNeoServer(config, configFile, dependencies, this.logProvider);
    }

    public File createConfigFiles() throws IOException {
        File temporaryConfigFile = ServerTestUtils.createTempConfigFile();
        File temporaryFolder = temporaryConfigFile.getParentFile();
        ServerTestUtils.writeConfigToFile(this.createConfiguration(temporaryFolder), temporaryConfigFile);
        return temporaryConfigFile;
    }

    public CommunityServerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    private Map<String, String> createConfiguration(File temporaryFolder) {
        String propertyKeys;
        Map properties = MapUtil.stringMap((String[])new String[]{ServerSettings.management_api_path.name(), this.webAdminUri, ServerSettings.rest_api_path.name(), this.webAdminDataUri});
        ServerTestUtils.addDefaultRelativeProperties(properties, temporaryFolder);
        if (this.dbDir != null) {
            properties.put(ServerSettings.legacy_db_location.name(), this.dbDir);
        }
        if (this.portNo != null) {
            properties.put(ServerSettings.webserver_port.name(), this.portNo);
        }
        if (this.host != null) {
            properties.put(ServerSettings.webserver_address.name(), this.host);
        }
        if (this.maxThreads != null) {
            properties.put(ServerSettings.webserver_max_threads.name(), this.maxThreads);
        }
        if (this.thirdPartyPackages.keySet().size() > 0) {
            properties.put(ServerSettings.third_party_packages.name(), ServerTestUtils.asOneLine(this.thirdPartyPackages));
        }
        if (this.autoIndexedNodeKeys != null && this.autoIndexedNodeKeys.length > 0) {
            properties.put("node_auto_indexing", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedNodeKeys, (String)",");
            properties.put("node_keys_indexable", propertyKeys);
        }
        if (this.autoIndexedRelationshipKeys != null && this.autoIndexedRelationshipKeys.length > 0) {
            properties.put("relationship_auto_indexing", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedRelationshipKeys, (String)",");
            properties.put("relationship_keys_indexable", propertyKeys);
        }
        if (this.securityRuleClassNames != null && this.securityRuleClassNames.length > 0) {
            propertyKeys = StringUtils.join((Object[])this.securityRuleClassNames, (String)",");
            properties.put(ServerSettings.security_rules.name(), propertyKeys);
        }
        if (this.httpsEnabled != null) {
            if (this.httpsEnabled.booleanValue()) {
                properties.put(ServerSettings.webserver_https_enabled.name(), "true");
            } else {
                properties.put(ServerSettings.webserver_https_enabled.name(), "false");
            }
        }
        properties.put(ServerSettings.auth_enabled.name(), "false");
        properties.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        for (Object key : this.arbitraryProperties.keySet()) {
            properties.put(String.valueOf(key), String.valueOf(this.arbitraryProperties.get(key)));
        }
        return properties;
    }

    protected CommunityServerBuilder(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public CommunityServerBuilder persistent() {
        this.persistent = true;
        return this;
    }

    public CommunityServerBuilder onPort(int portNo) {
        this.portNo = String.valueOf(portNo);
        return this;
    }

    public CommunityServerBuilder withMaxJettyThreads(int maxThreads) {
        this.maxThreads = String.valueOf(maxThreads);
        return this;
    }

    public CommunityServerBuilder usingDatabaseDir(String dbDir) {
        this.dbDir = dbDir;
        return this;
    }

    public CommunityServerBuilder withRelativeWebAdminUriPath(String webAdminUri) {
        try {
            URI theUri = new URI(webAdminUri);
            this.webAdminUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withRelativeWebDataAdminUriPath(String webAdminDataUri) {
        try {
            URI theUri = new URI(webAdminDataUri);
            this.webAdminDataUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withDefaultDatabaseTuning() {
        return this;
    }

    public CommunityServerBuilder withThirdPartyJaxRsPackage(String packageName, String mountPoint) {
        this.thirdPartyPackages.put(packageName, mountPoint);
        return this;
    }

    public CommunityServerBuilder withAutoIndexingEnabledForNodes(String ... keys) {
        this.autoIndexedNodeKeys = keys;
        return this;
    }

    public CommunityServerBuilder onHost(String host) {
        this.host = host;
        return this;
    }

    public CommunityServerBuilder withSecurityRules(String ... securityRuleClassNames) {
        this.securityRuleClassNames = securityRuleClassNames;
        return this;
    }

    public CommunityServerBuilder withHttpsEnabled() {
        this.httpsEnabled = Boolean.TRUE;
        return this;
    }

    public CommunityServerBuilder withProperty(String key, String value) {
        this.arbitraryProperties.put(key, value);
        return this;
    }

    public CommunityServerBuilder withPreflightTasks(PreflightTask ... tasks) {
        this.preflightTasks = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), tasks);
        return this;
    }

    protected DatabaseActions createDatabaseActionsObject(Database database, Config config) {
        Clock clockToUse = this.clock != null ? this.clock : Clock.SYSTEM_CLOCK;
        return new DatabaseActions(new LeaseManager(clockToUse), ((Boolean)config.get(ServerSettings.script_sandboxing_enabled)).booleanValue(), database.getGraph());
    }

    protected File buildBefore() throws IOException {
        File configFile = this.createConfigFiles();
        if (this.preflightTasks == null) {
            this.preflightTasks = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), new PreflightTask[0]){

                public boolean run() {
                    return true;
                }
            };
        }
        return configFile;
    }

    private class TestCommunityNeoServer
    extends CommunityNeoServer {
        private final File configFile;

        private TestCommunityNeoServer(Config config, File configFile, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
            super(config, LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)(CommunityServerBuilder.this.persistent ? COMMUNITY_FACTORY : IN_MEMORY_DB)), dependencies, logProvider);
            this.configFile = configFile;
        }

        protected DatabaseActions createDatabaseActions() {
            return CommunityServerBuilder.this.createDatabaseActionsObject(this.database, this.getConfig());
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }
}

