/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.configuration.Configuration;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.modules.ExtensionInitializer;
import org.neo4j.server.plugins.Injectable;
import org.neo4j.server.plugins.PluginLifecycle;

public class ExtensionInitializerTest {
    @Test
    public void testPluginInitialization() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{ServerSettings.transaction_timeout.name(), "600"}));
        NeoServer neoServer = (NeoServer)Mockito.mock(NeoServer.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)neoServer.getConfig()).thenReturn((Object)config);
        ExtensionInitializer extensionInitializer = new ExtensionInitializer(neoServer);
        Collection injectableProperties = extensionInitializer.initializePackages(Arrays.asList("org.neo4j.server.modules"));
        Assert.assertThat((Object)injectableProperties, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)injectableProperties, (Matcher)Matchers.contains(new InjectableMatcher<String>(ServerSettings.transaction_timeout.name())));
    }

    public static class PropertyCollectorPlugin
    implements PluginLifecycle {
        public Collection<Injectable<?>> start(GraphDatabaseService graphDatabaseService, Configuration config) {
            return Iterables.toList((Iterator)Iterables.map((Function)new StringToInjectableFunction(), (Iterator)config.getKeys()));
        }

        public void stop() {
        }

        private class StringToInjectableFunction
        implements Function<String, Injectable<?>> {
            private StringToInjectableFunction() {
            }

            @Override
            public Injectable<String> apply(final String value) {
                return new Injectable<String>(){

                    public String getValue() {
                        return value;
                    }

                    public Class<String> getType() {
                        return String.class;
                    }
                };
            }
        }
    }

    private class InjectableMatcher<T>
    extends BaseMatcher<Injectable<?>> {
        private T value;

        public InjectableMatcher(T value) {
            this.value = value;
        }

        public boolean matches(Object o) {
            return o instanceof Injectable && this.value.equals(((Injectable)o).getValue());
        }

        public void describeMismatch(Object o, Description description) {
            description.appendValue((Object)String.format("Expect Injectable with value: '%s', but actual value was: '%s'", this.value, o));
        }

        public void describeTo(Description description) {
        }
    }
}

