/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import com.sun.jersey.core.util.Base64;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;

public class AuthorizationHeadersTest {
    @Test
    public void shouldParseHappyPath() throws Exception {
        String username = "jake";
        String password = "qwerty123456";
        String header = "Basic " + this.base64(username + ":" + password);
        String[] parsed = AuthorizationHeaders.decode((String)header);
        Assert.assertEquals((Object)username, (Object)parsed[0]);
        Assert.assertEquals((Object)password, (Object)parsed[1]);
    }

    @Test
    public void shouldHandleSadPaths() throws Exception {
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)""));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)"Basic"));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)"Basic not valid value"));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)("Basic " + this.base64(""))));
    }

    private String base64(String value) {
        return UTF8.decode((byte[])Base64.encode((String)value));
    }
}

