/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional.integration;

import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.repr.util.RFC1123;
import org.neo4j.test.server.HTTP;

public class TransactionMatchers {
    static Matcher<String> isValidRFCTimestamp() {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                try {
                    return RFC1123.parseTimestamp((String)item).getTime() > 0L;
                }
                catch (ParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("valid RFC1134 timestamp");
            }
        };
    }

    static Matcher<String> matches(final String pattern) {
        final Pattern regex = Pattern.compile(pattern);
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                return regex.matcher(item).matches();
            }

            public void describeTo(Description description) {
                description.appendText("matching regex: ").appendValue((Object)pattern);
            }
        };
    }

    public static Matcher<? super HTTP.Response> containsNoErrors() {
        return TransactionMatchers.hasErrors(new Status[0]);
    }

    public static Matcher<? super HTTP.Response> hasErrors(final Status ... expectedErrors) {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    Iterator errors = response.get("errors").iterator();
                    Iterator expected = IteratorUtil.iterator((Object[])expectedErrors);
                    while (expected.hasNext()) {
                        Assert.assertTrue((boolean)errors.hasNext());
                        MatcherAssert.assertThat((Object)((JsonNode)errors.next()).get("code").asText(), (Matcher)CoreMatchers.equalTo((Object)((Status)expected.next()).code().serialize()));
                    }
                    if (errors.hasNext()) {
                        JsonNode error = (JsonNode)errors.next();
                        Assert.fail((String)("Expected no more errors, but got " + error.get("code") + " - '" + error.get("message") + "'."));
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    static JsonNode getJsonNodeWithName(HTTP.Response response, String name) throws JsonParseException {
        return response.get("results").get(0).get("data").get(0).get(name);
    }

    public static Matcher<? super HTTP.Response> rowContainsDeletedEntities(final int nodes, final int rels) {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    Iterator meta = TransactionMatchers.getJsonNodeWithName(response, "meta").iterator();
                    int nodeCounter = 0;
                    int relCounter = 0;
                    block10: for (int i = 0; i < nodes + rels; ++i) {
                        String type;
                        Assert.assertTrue((boolean)meta.hasNext());
                        JsonNode node = (JsonNode)meta.next();
                        MatcherAssert.assertThat((Object)node.get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                        switch (type = node.get("type").getTextValue()) {
                            case "node": {
                                ++nodeCounter;
                                continue block10;
                            }
                            case "relationship": {
                                ++relCounter;
                                continue block10;
                            }
                            default: {
                                Assert.fail((String)("Unexpected type: " + type));
                            }
                        }
                    }
                    Assert.assertEquals((long)nodes, (long)nodeCounter);
                    Assert.assertEquals((long)rels, (long)relCounter);
                    while (meta.hasNext()) {
                        JsonNode node = (JsonNode)meta.next();
                        MatcherAssert.assertThat((Object)node.get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.FALSE));
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static Matcher<? super HTTP.Response> restContainsDeletedEntities(final int amount) {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    Iterator entities = TransactionMatchers.getJsonNodeWithName(response, "rest").iterator();
                    for (int i = 0; i < amount; ++i) {
                        Assert.assertTrue((boolean)entities.hasNext());
                        JsonNode node = (JsonNode)entities.next();
                        MatcherAssert.assertThat((Object)node.get("metadata").get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                    }
                    if (entities.hasNext()) {
                        Assert.fail((String)"Expected no more entities");
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static Matcher<? super HTTP.Response> graphContainsDeletedNodes(final int amount) {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    Iterator nodes = TransactionMatchers.getJsonNodeWithName(response, "graph").get("nodes").iterator();
                    for (int i = 0; i < amount; ++i) {
                        Assert.assertTrue((boolean)nodes.hasNext());
                        JsonNode node = (JsonNode)nodes.next();
                        MatcherAssert.assertThat((Object)node.get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                    }
                    while (nodes.hasNext()) {
                        JsonNode node = (JsonNode)nodes.next();
                        Assert.assertNull((Object)node.get("deleted"));
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static Matcher<? super HTTP.Response> graphContainsNoDeletedEntities() {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    for (JsonNode node : TransactionMatchers.getJsonNodeWithName(response, "graph").get("nodes")) {
                        Assert.assertNull((Object)node.get("deleted"));
                    }
                    for (JsonNode node : TransactionMatchers.getJsonNodeWithName(response, "graph").get("relationships")) {
                        Assert.assertNull((Object)node.get("deleted"));
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static Matcher<? super HTTP.Response> rowContainsNoDeletedEntities() {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    for (JsonNode node : TransactionMatchers.getJsonNodeWithName(response, "meta")) {
                        Assert.assertFalse((boolean)node.get("deleted").asBoolean());
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static Matcher<? super HTTP.Response> restContainsNoDeletedEntities() {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    for (JsonNode node : TransactionMatchers.getJsonNodeWithName(response, "rest")) {
                        Assert.assertNull((Object)node.get("metadata").get("deleted"));
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static Matcher<? super HTTP.Response> graphContainsDeletedRelationships(final int amount) {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                try {
                    Iterator relationships = TransactionMatchers.getJsonNodeWithName(response, "graph").get("relationships").iterator();
                    for (int i = 0; i < amount; ++i) {
                        Assert.assertTrue((boolean)relationships.hasNext());
                        JsonNode node = (JsonNode)relationships.next();
                        MatcherAssert.assertThat((Object)node.get("deleted").asBoolean(), (Matcher)CoreMatchers.equalTo((Object)Boolean.TRUE));
                    }
                    if (relationships.hasNext()) {
                        JsonNode node = (JsonNode)relationships.next();
                        Assert.fail((String)("Expected no more nodes, but got a node with id " + node.get("id")));
                    }
                    return true;
                }
                catch (JsonParseException e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
            }
        };
    }

    public static long countNodes(GraphDatabaseService graphdb) {
        try (Transaction ignore = graphdb.beginTx();){
            long count = 0L;
            ResourceIterator allNodes = graphdb.getAllNodes().iterator();
            while (allNodes.hasNext()) {
                allNodes.next();
                ++count;
            }
            long l = count;
            return l;
        }
    }

    public static Matcher<? super HTTP.Response> containsNoStackTraces() {
        return new TypeSafeMatcher<HTTP.Response>(){

            protected boolean matchesSafely(HTTP.Response response) {
                Map content = (Map)response.content();
                List errors = (List)content.get("errors");
                for (Map error : errors) {
                    if (!error.containsKey("stackTrace")) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("contains stack traces");
            }
        };
    }
}

