/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.web;

import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.web.DatabaseMetadataService;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DatabaseMetadataServiceTest {
    @Test
    public void shouldAdvertiseRelationshipTypesThatCurrentlyExistInTheDatabase() throws Throwable {
        long relId;
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)"a"));
            node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)"b"));
            relId = node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)"c")).getId();
            tx.success();
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            db.getRelationshipById(relId).delete();
            tx.success();
        }
        catch (Throwable node) {
            var5_3 = node;
            throw node;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node) {
                        var5_3.addSuppressed(node);
                    }
                } else {
                    tx.close();
                }
            }
        }
        WrappedDatabase database = new WrappedDatabase(db);
        DatabaseMetadataService service = new DatabaseMetadataService((Database)database);
        try (Transaction tx = db.beginTx();){
            Response response = service.getRelationshipTypes(false);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            List jsonList = JsonHelper.jsonToList((String)response.getEntity().toString());
            Assert.assertEquals((long)3L, (long)jsonList.size());
        }
        database.stop();
    }

    @Test
    public void shouldAdvertiseRelationshipTypesThatCurrentlyInUseInTheDatabase() throws Throwable {
        long relId;
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)"a"));
            node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)"b"));
            relId = node.createRelationshipTo(db.createNode(), RelationshipType.withName((String)"c")).getId();
            tx.success();
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            db.getRelationshipById(relId).delete();
            tx.success();
        }
        catch (Throwable node) {
            var5_3 = node;
            throw node;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node) {
                        var5_3.addSuppressed(node);
                    }
                } else {
                    tx.close();
                }
            }
        }
        WrappedDatabase database = new WrappedDatabase(db);
        DatabaseMetadataService service = new DatabaseMetadataService((Database)database);
        try (Transaction tx = db.beginTx();){
            Response response = service.getRelationshipTypes(true);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            List jsonList = JsonHelper.jsonToList((String)response.getEntity().toString());
            Assert.assertEquals((long)2L, (long)jsonList.size());
        }
        database.stop();
    }
}

