/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.UTF8;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.rest.management.console.ConsoleService;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.webadmin.console.ConsoleSessionFactory;
import org.neo4j.server.webadmin.console.ScriptSession;

public class ConsoleServiceDocTest {
    private final URI uri = URI.create("http://peteriscool.com:6666/");

    @Test
    public void correctRepresentation() throws URISyntaxException {
        ConsoleService consoleService = new ConsoleService((ConsoleSessionFactory)new ShellOnlyConsoleSessionFactory(), (Database)Mockito.mock(Database.class), (LogProvider)NullLogProvider.getInstance(), new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
        Response consoleResponse = consoleService.getServiceDefinition();
        Assert.assertEquals((long)200L, (long)consoleResponse.getStatus());
        String response = this.decode(consoleResponse);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"resources"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)this.uri.toString()));
    }

    @Test
    public void advertisesAvailableConsoleEngines() throws URISyntaxException {
        ConsoleService consoleServiceWithJustShellEngine = new ConsoleService((ConsoleSessionFactory)new ShellOnlyConsoleSessionFactory(), (Database)Mockito.mock(Database.class), (LogProvider)NullLogProvider.getInstance(), new OutputFormat((RepresentationFormat)new JsonFormat(), this.uri, null));
        String response = this.decode(consoleServiceWithJustShellEngine.getServiceDefinition());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\"engines\" : [ \"shell\" ]"));
    }

    private String decode(Response response) {
        return UTF8.decode((byte[])((byte[])response.getEntity()));
    }

    private static class ShellOnlyConsoleSessionFactory
    implements ConsoleSessionFactory {
        private ShellOnlyConsoleSessionFactory() {
        }

        public ScriptSession createSession(String engineName, Database database, LogProvider logProvider) {
            return null;
        }

        public Iterable<String> supportedEngines() {
            return Collections.singletonList("shell");
        }
    }
}

