(function(define){
define(function(){return function(vars){
with(vars||{}) {
return "<div class=\"sidebar\"><p class=\"pad\">The Neo4j Shell, allows you to use the Cypher query language for working with your graph, as well as other powerful shell features.</p><p class=\"pad\">For command reference, see <a href=\"http://neo4j.com/docs/3.0.0-M05/shell-commands.html\" target=\"_BLANK\">the shell documentation</a>.</p><p class=\"pad\">For Cypher syntax help, see <a href=\"http://neo4j.com/docs/3.0.0-M05/cypher-query-lang.html\" target=\"_BLANK\">the Cypher documentation</a>. Remember to end your queries with a semicolon!</p><div class=\"foldout\"><h2><a href=\"#\" class=\"foldout_trigger\">Cheat sheet</a></h2><div class=\"foldout_content\"><ul class=\"info_list\"><li><h3>Get node with id 0</h3><p>START a = node(0)</p><p>RETURN a;</p></li><li><h3>Get all nodes connects to node with id 0</h3><p>START a = node(0)</p><p>MATCH a-->b</p><p>RETURN b;</p></li><li><h3>Get all nodes connected to node with id 0, and the relationships</h3><p>START a = node(0)</p><p>MATCH a-[r]->b</p><p>RETURN r, b;</p></li><li><h3>Get all nodes related to node with id 0 with relationship type KNOWS</h3><p>START a = node(0)</p><p>MATCH a-[:KNOWS]->b</p><p>RETURN b;</p></li><li><h3>Get all nodes from index \"people\", with key \"name\", matching value \"Doctor\"</h3><p>START a = node:people( name= \"Doctor\")</p><p>RETURN a;</p></li><li><h3>Get all nodes connected to the doctor</h3><p>START doctor = node:people(name=\"Doctor\")</p><p>MATCH doctor-[:ENEMY_OF]->enemy</p><p>WHERE enemy.name = \"Cybermen\"</p><p>RETURN doctor;</p></li><li><h3>Get all friends of friends of the doctor</h3><p>START doctor = node:people( name=\"Doctor\")</p><p>MATCH doctor-[:FRIEND]->friend-[:FRIEND]->friend_of_friend</p><p>RETURN friend_of_friend;</p></li></ul></div></div><div class=\"foldout\"><h2><a href=\"#\" class=\"foldout_trigger\">If the console hangs</a></h2><div class=\"foldout_content\"><p class=\"pad\">If the console hangs, you can reset it by clearing your browser cookies for webadmin.</p></div></div></div><div class=\"workarea with-sidebar\" id=\"console-base\"></div>"; 
}};
});})(typeof define=="function"?
define:
function(factory){module.exports=factory.apply(this, deps.map(require));});
