/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.Bootstrapper;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.server.ExclusiveServerTestBase;

public abstract class BaseBootstrapperTest
extends ExclusiveServerTestBase {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    protected Bootstrapper bootstrapper;

    protected String[] commandLineConfig(String ... params) {
        ArrayList config = new ArrayList();
        Collections.addAll(config, params);
        return config.toArray(new String[config.size()]);
    }

    @Before
    public void before() throws IOException {
        this.bootstrapper = this.newBootstrapper();
    }

    @After
    public void after() {
        if (this.bootstrapper != null) {
            this.bootstrapper.stop();
        }
    }

    protected abstract Bootstrapper newBootstrapper() throws IOException;

    @Test
    public void shouldStartStopNeoServerWithoutAnyConfigFiles() throws IOException {
        int resultCode = CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig("-c", this.configOption(DatabaseManagementSystemSettings.data_directory.name(), this.tempDir.getRoot().getAbsolutePath()), "-c", this.configOption(GraphDatabaseSettings.auth_store.name(), this.tempDir.newFile().getAbsolutePath()), "-c", this.configOption(ServerSettings.tls_certificate_file.name(), new File(this.tempDir.getRoot(), "cert.cert").getAbsolutePath()), "-c", this.configOption(ServerSettings.tls_key_file.name(), new File(this.tempDir.getRoot(), "key.key").getAbsolutePath())));
        Assert.assertEquals((long)0L, (long)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
    }

    @Test
    public void canSpecifyConfigFile() throws Throwable {
        File configFile = this.tempDir.newFile("neo4j.config");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "ourcustomvalue"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        MapUtil.store((Map)properties, (File)configFile);
        CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig("-C", configFile.getAbsolutePath()));
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"ourcustomvalue"));
    }

    @Test
    public void canOverrideConfigValues() throws Throwable {
        File configFile = this.tempDir.newFile("neo4j.config");
        Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.forced_kernel_id.name(), "thisshouldnotshowup"});
        properties.putAll(ServerTestUtils.getDefaultRelativeProperties());
        MapUtil.store((Map)properties, (File)configFile);
        CommunityBootstrapper.start((Bootstrapper)this.bootstrapper, (String[])this.commandLineConfig("-C", configFile.getAbsolutePath(), "-c", this.configOption(GraphDatabaseSettings.forced_kernel_id.name(), "mycustomvalue")));
        Assert.assertThat((Object)this.bootstrapper.getServer().getConfig().get(GraphDatabaseSettings.forced_kernel_id), (Matcher)Matchers.equalTo((Object)"mycustomvalue"));
    }

    protected String configOption(String key, String value) {
        return key + "=" + value;
    }
}

